define(['./task_list_type.component.html'], function (template)
{
    var TaskListType = {
        bindings: {
            ngModel: '=',
            listName: '@',
            dateName: '@'
        },
        templateUrl: template,
        transclude: true,
        controller: [
            function () {
                var ctrl = this;

                ctrl.$onInit = function() {
                    if ((ctrl.ngModel !== 'list_view') &&
                        (ctrl.ngModel !== 'date_view'))
                    {
                        ctrl.ngModel = 'list_view';
                    }
                };

                ctrl.changeView = function(view, $event)
                {
                    $event.preventDefault();

                    ctrl.ngModel = view === 'list_view' ? 'list_view' : 'date_view';
                };
            }
        ]
    };

    return TaskListType;
});
