define(['./checkbox.component.html'], function (template)
{
    var Checkbox = {
        bindings: {
            ngModel: '=',
            large: '@',
            name: '@',
            disabled: '@',
        },
        require: { ngModelCtrl: 'ngModel' },
        templateUrl: template,
        transclude: true,
        controller: function () {
            var ctrl = this;

            ctrl.$onInit = function() {
                if (ctrl.disabled === undefined)
                    ctrl.disabled = false;
            };

            ctrl.onChecked = function($event) {
                $event.preventDefault();

                ctrl.ngModel = true;
                ctrl.ngModelCtrl.$setViewValue(ctrl.ngModel);
            }

            ctrl.onUnchecked = function($event) {
                $event.preventDefault();

                ctrl.ngModel = false;
                ctrl.ngModelCtrl.$setViewValue(ctrl.ngModel);
            }
        }
    };

    return Checkbox;
});
