<?php
namespace Claromentis\Projects\Controller;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] ?: array()) + array("_f4afc0b7f4289969aa2" . "dc5100728731f" => base64_decode("cHJvamVj" . "dHMucmVz" . "dC5ub19w" . "cm9qZWN0"), "_0ea4e32b57963ac0cb" . "3057e03e9aef64" => base64_decode("a" . "W" . "Q" . "="), "_9ed84d2923d81db75e6348d1b290c05" . "1" => base64_decode("Y29tcGxldGVkX3N0YXR1c1" . "9sYWJlbA=="), "_80f432640c97e" . "2aa412664c408f" . "72221" => base64_decode("Q2Fubm90IGR" . "lbGV0ZSBpbm" . "l0aWFsIHN0Y" . "XR1cw=="), "_b94c0530a0f" . "c19421865e1e" . "fa5f6779f" => base64_decode("Tm8gc3RhdHVzIElE" . "IA=="), "sta" . "tus" => base64_decode("c3" . "Rh" . "dH" . "Vz"), "_f805302e3f25df" . "291a3dd8ea386da" . "8a4" => base64_decode("IGluIH" . "Byb2pl" . "Y3Qg"), "_a29b27c98290e9" . "26d8b084b48c9ce" . "369" => base64_decode("WW91IGRvIG5vdCBoYXZlIHBlcm1pc3Npb24gdG8gZWRpdCB0aGUgbGlzdCBvZiBzdGF0dXNlc" . "w=="), "_068ab9b9340314c" . "5b07e3e5cc31d925" . "b" => base64_decode("c29ydF9vcmRlc" . "g=="), "_8dabb06efc" . "95df4cff7c4" . "afe91857b53" => base64_decode("bmF" . "tZQ" . "=="), "statu" . "ses" => base64_decode("c3RhdHVzZX" . "M="), "_f33594668a14ecd5ede1fb90b8354c7" . "0" => base64_decode("TmV3IHN0YXR1cyBtdXN0I" . "GhhdmUgbmFtZQ=="), "_8f4004bb39963606d04252" . "4cafb2c56e" => base64_decode("Tm8gbmFt" . "ZSBnaXZl" . "bg=="), "_5f4d1ad89c9" . "41500471a837" . "0398dad9e" => base64_decode("dG9kb19zd" . "GF0dXNfbG" . "FiZWw="), "_4d23892ff91aa3195a" . "85bb548a7f4333" => base64_decode("bG9jYWxpemVkX" . "25hbWU="), "_7d5f0a31f61b7b734f21a9bf6acf250" . "2" => base64_decode("Q2Fubm90IGRlbGV0ZSB" . "maW5hbCBzdGF0dXM="));
use Analogue\ORM\Exceptions\MappingException;
use Claromentis\Core\CDN;
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Projects\Entity\TaskStatus;
use Claromentis\Projects\Exceptions\StatusStorageException;
use Claromentis\Projects\Model\Task;
use Claromentis\Projects\Permissions;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\TaskStatusApi;
use Psr\Http\Message\ServerRequestInterface;
class TaskStatusController
{
    
    
    
    
    protected $api;
    
    
    
    
    protected $project_provider;
    
    
    
    
    protected $formatter;
    
    
    
    
    protected $lmsg;
    public function __construct(TaskStatusApi $api, ProjectRepository $project_provider, RestFormatter $formatter, Lmsg $lmsg)
    {
        $this->api = $api;
        $this->project_provider = $project_provider;
        $this->formatter = $formatter;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    public function ShowList(int $project_id) : JsonPrettyResponse
    {
        $project = $this->project_provider->GetProject($project_id);
        if (!$project) {
            throw new \RestExNotFound(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f4afc0b7f4289969aa2dc5100" . "728731f"]));
        }
        $statuses = $this->api->getProjectStatuses($project)->all();
        return new JsonPrettyResponse([[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["status" . "es"] => $this->FormatStatuses($statuses)]]);
    }
    
    
    
    
    
    
    
    
    
    public function Show(int $project_id, TaskStatus $status) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["stat" . "us"] => $this->FormatStatus($status)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Update(int $project_id, TaskStatus $status, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $_231341bedbbeea0ba9fa8da63ef63dc1 = $status->id === 0;
        $_a71dc9333bd8ad95d55d6624b477875f = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_9bacb470d4f91e74f3caafec23aeca8e = clone $status;
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $status->project_id = $project_id;
            if (empty($_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_8dabb06efc95df4cff7" . "c4afe91857b53"]])) {
                throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f33594668a14ecd5e" . "de1fb90b8354c70"]);
            }
        }
        $status->sort_order = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_068ab9b9340314c5b07e3e" . "5cc31d925b"]] ?? $status->sort_order;
        $status->name = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_8dabb06efc95df4c" . "ff7c4afe91857b53"]] ?? $status->name;
        $this->api->SaveStatus($status);
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $this->api->StatusAddedHistory($status);
        } else {
            $this->api->StatusUpdatedHistory($_9bacb470d4f91e74f3caafec23aeca8e, $status);
        }
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["st" . "at" . "us"] => $this->FormatStatus($status)], $_231341bedbbeea0ba9fa8da63ef63dc1 ? 201 : 200);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateV3(int $project_id, TaskStatus $status, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $_231341bedbbeea0ba9fa8da63ef63dc1 = $status->id === 0;
        $_a71dc9333bd8ad95d55d6624b477875f = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_9bacb470d4f91e74f3caafec23aeca8e = clone $status;
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $status->project_id = $project_id;
            if (empty($_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8dabb06efc95df4cff7c4" . "afe91857b53"]])) {
                throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f33594668a14ecd5ede1fb" . "90b8354c70"]);
            }
        }
        $status->sort_order = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_068ab9b9340314c5b07e3e5" . "cc31d925b"]] ?? $status->sort_order;
        $status->name = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8dabb06efc9" . "5df4cff7c4af" . "e91857b53"]] ?? $status->name;
        $this->api->SaveStatus($status);
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $this->api->StatusAddedHistory($status);
        } else {
            $this->api->StatusUpdatedHistory($_9bacb470d4f91e74f3caafec23aeca8e, $status);
        }
        $_1833c1908972ebd0c77f861e80c2d9bf = $this->api->getProjectStatuses($project_id);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["statu" . "s"] => $this->FormatStatus($status), $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["st" . "at" . "us" . "es"] => $this->FormatStatuses($_1833c1908972ebd0c77f861e80c2d9bf)], $_231341bedbbeea0ba9fa8da63ef63dc1 ? 201 : 200);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function Delete(int $project_id, TaskStatus $status, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $this->api->DeleteStatus($status);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["st" . "at" . "us"] => $this->FormatStatus($status)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function DeleteV3(int $project_id, TaskStatus $status, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $this->api->DeleteStatus($status);
        $_1833c1908972ebd0c77f861e80c2d9bf = $this->api->getProjectStatuses($project_id);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["statu" . "s"] => $this->FormatStatus($status), $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["statu" . "ses"] => $this->FormatStatuses($_1833c1908972ebd0c77f861e80c2d9bf)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateTodo(PermissionsChecker $permissions_checker, int $project_id, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6) : JsonPrettyResponse
    {
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $project = $this->project_provider->GetProject($project_id);
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if (!$project) {
            throw new \RestExBadRequest(($this->lmsg)($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_f4afc0b7f428" . "9969aa2dc5100" . "728731f"]));
        }
        if (!isset($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_8dabb06efc95df4cff7" . "c4afe91857b53"]])) {
            throw new \RestExBadRequest($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_8f4004bb39963606d" . "042524cafb2c56e"]);
        }
        $project->SetProperty($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_5f4d1ad89c94150047" . "1a8370398dad9e"], $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_8dabb06ef" . "c95df4cff7" . "c4afe91857" . "b53"]]);
        $this->project_provider->SaveProject($project);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["statu" . "s"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_0ea4e32b57" . "963ac0cb305" . "7e03e9aef64"] => Task::STATUS_TODO, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_8dabb06efc95df4cff7c4afe" . "91857b53"] => $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_8dabb06efc95df4cff7c4afe918" . "57b53"]], $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4d23892ff91aa3195a85bb54" . "8a7f4333"] => $this->lmsg->lmsg_str($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8dabb06efc95df4cf" . "f7c4afe91857b53"]])]]);
    }
    public function DeleteTodo()
    {
        throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_80f432640c97e2aa412664c" . "408f72221"]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateCompleted(PermissionsChecker $permissions_checker, int $project_id, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6) : JsonPrettyResponse
    {
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $project = $this->project_provider->GetProject($project_id);
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if (!$project) {
            throw new \RestExBadRequest(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_f4afc0b" . "7f428996" . "9aa2dc51" . "00728731" . "f"]));
        }
        if (!isset($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8dabb06e" . "fc95df4cf" . "f7c4afe91" . "857b53"]])) {
            throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_8f4004bb39963606d042524cafb2c" . "56e"]);
        }
        $project->SetProperty($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_9ed84d2" . "923d81db" . "75e6348d" . "1b290c05" . "1"], $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8dabb06efc95df4cff7" . "c4afe91857b53"]]);
        $this->project_provider->SaveProject($project);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["stat" . "us"] => [$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_0ea4e32b57963ac0cb3057e03e9ae" . "f64"] => Task::STATUS_COMPLETED, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_8dabb06efc95d" . "f4cff7c4afe918" . "57b53"] => $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8dabb06efc95df4" . "cff7c4afe91857b5" . "3"]], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_4d23892ff9" . "1aa3195a85b" . "b548a7f4333"] => $this->lmsg->lmsg_str($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8dabb06efc95" . "df4cff7c4afe9" . "1857b53"]])]]);
    }
    public function DeleteCompleted()
    {
        throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_7d5f0a31f61b7b734f21a9bf6acf250" . "2"]);
    }
    
    
    
    
    
    
    
    private function CheckEditPermissions(int $project_id, PermissionsChecker $permissions_checker)
    {
        if (!$permissions_checker->CanI($project_id, Permissions::EDIT_PROJECT_PROPERTIES)) {
            throw new \RestExForbidden($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_a29b27c98290e92" . "6d8b084b48c9ce36" . "9"]);
        }
    }
    
    
    
    
    
    
    
    private function CheckProjectId(int $project_id, TaskStatus $status)
    {
        if ($status->project_id && $project_id !== $status->project_id) {
            throw new \RestExNotFound($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_b94c0530a0fc19421865e1ef" . "a5f6779f"] . $status->id . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f805302e3f25df291a3dd8ea38" . "6da8a4"] . $project_id);
        }
    }
    private function FormatStatuses($statuses) : array
    {
        $_e8180e518b009dc0ea8c578fe193c4ae = [];
        
        
        foreach ($statuses as $status) {
            $_e8180e518b009dc0ea8c578fe193c4ae[] = $this->FormatStatus($status);
        }
        return $_e8180e518b009dc0ea8c578fe193c4ae;
    }
    
    
    
    
    
    
    private function FormatStatus(TaskStatus $status) : array
    {
        $status = $status->toArray();
        $status[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4d23892ff91" . "aa3195a85bb5" . "48a7f4333"]] = $this->lmsg->lmsg_str($status[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_8dabb06efc95df4cff7c4afe91857b" . "53"]]);
        return $status;
    }
}