// Main page controller to update project list according to filters, search and pagination
(function()
{
	var moduleName = 'projectListApp';

	angular.module(moduleName)
		.controller("projectListCtrl", ['$scope', '$http', '$localStorage', '$timeout', 'breadcrumb.service', 'claProjectListService', 'confirmService', projectListController]);

	function projectListController($scope, $http, $localStorage, $timeout, breadcrumbService, service, confirmService)
	{
        $scope.projects = [];
        var projects = service.getProjects();

        for (var i = 0; i < projects.length; i++)
        {
            $scope.projects.push(projects[i]);
        }

        // Set up pagination vars
        $scope.isIE = /msie\s|trident\/|edge\//i.test(window.navigator.userAgent);
        $scope.currentPage = current_page;
        $scope.searchTerms = searchTerms;
        $scope.companyId = project_company_filter;
        $scope.sortOrder = sort;

        // Set up filter vars and highlight the right one
        $scope.filters = service.getFilters();

        breadcrumbService.setCrumbs(
            [
                {
                    'url': '/projects',
                    'name': lmsg('projects.breadcrumb.projects')
                }
            ]);

        service.registerCallback(function(){
            $scope.projects.length = 0;
            var projects = service.getProjects();

            for (var i = 0; i < projects.length; i++)
            {
                $scope.projects.push(projects[i]);
            }

            $timeout(function(){
                $scope.$digest();
            }, 0);
        });

        // View layout, saved in local storage
        $scope.$storage = $localStorage.$default({
            layoutType: 'list-thumbnail'
        });

        $scope.changeLayout = function(layout){
            $scope.$storage.layoutType = layout;
        };

        // Sorting
        $scope.changeSortOrder = function($event, orderby) {
            $event.preventDefault();

            if (orderby === $scope.sortOrder)
                return;

            service.changeSortOrder(orderby);
            $scope.sortOrder = orderby;
        };

        $scope.statusClasses =
            {
                1: 'warning',  // Draft
                2: 'success',  // Live
                3: 'info',     // On hold
                4: 'secondary' // Archived
            };

        // Bookmarks
        $scope.toggleBookmark = function($event, project_id, bookmark)
        {
            $event.preventDefault();

            service.toggleBookmark(project_id, bookmark);
		};

        // If pagination is clicked
        $scope.pageChanged = function(newPage) {
            $scope.currentPage = newPage;
            service.pageChanged(newPage);
        };

        $scope.search = function($event)
        {
            if ($event !== undefined)
                $event.preventDefault();

            service.search($scope.searchTerms);
        };

        $scope.getTotalCount = function()
        {
            return service.totalCount;
        }

        $scope.getCurrentPage = function()
        {
            return service.currentPage;
        }

        $scope.getProjectsPerPage = function()
        {
            return service.projectsPerPage;
        }

        $scope.confirmDelete = function(event, project_id)
        {
            event.preventDefault();

            confirmService.show({
                title: lmsg('projects.project.delete_project.title'),
                message: lmsg('projects.project.delete_confirm'),
            }).then(function() {
                service.deleteProject(project_id);
            }, function() {});
        }
    }
}());
