(function()
{
    var moduleName = 'claromentis.project';
    var template = require('../../html/directives/history_status.directive.html');

    angular.module(moduleName)
        .directive('historyStatus', historyStatus);

    historyStatus.$inject = ['claProjectsHistoryService'];
    function historyStatus(service)
    {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                status: '<',
                statusStr: '<'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.getStatusName = function()
            {
                var name = service.getStatusName(parseInt(ctrl.status));

                if (name !== null)
                    return name;
                else
                    return ctrl.statusStr;
            }
        }
    }
}());
