define([], function ()
{
    var ConfirmService = function($q) {
        var service = this;

        service.promise = null;
        service.confirmDialog = null;

        service.registerConfirmDialog = function(dialog) {
            if (service.confirmDialog !== null)
                console.error('ConfirmService error: Multiple <clang-confirm> instances exist, only one should be defined per page');

            service.confirmDialog = dialog;
        };

        service.show = function(settings) {
            if (service.confirmDialog === null)
            {
                console.error('Confirmation dialog not found');
                return;
            }
            service.confirmDialog(settings);

            angular.element('#projects-confirm').modal('show');
            service.promise = $q.defer();

            return service.promise.promise;
        };

        service.resolve = function() {
            angular.element('#projects-confirm').modal('hide');
            service.promise.resolve();
        };

        service.reject = function() {
            angular.element('#projects-confirm').modal('hide');
            service.promise.reject();
        };
    };
    ConfirmService.$inject = ['$q'];

    return ConfirmService;
});
