(function()
{
    var moduleName = 'cla.projects_history';

    angular.module(moduleName, [])
        .service('claProjectsHistoryService', ['historyPreloadFactory', projectHistoryService]);

    function projectHistoryService(historyPreloadFactory)
    {
        var service = this;

        service.statuses = historyPreloadFactory.statuses;
        service.lists = historyPreloadFactory.lists;

        service.getStatusName = function(status_id) {
            for (var statusIndex = 0; statusIndex < service.statuses.length; statusIndex++)
            {
                if (service.statuses[statusIndex].id === status_id)
                    return service.statuses[statusIndex].name;
            }

            return null;
        };

        service.getListName = function(list_id) {
            for (var listIndex = 0; listIndex < service.lists.length; listIndex++)
            {
                if (service.lists[listIndex].id === list_id)
                    return service.lists[listIndex].title;
            }

            return null;
        };
    }
}());
