(function()
{
    var moduleName = 'cla.service.project_task_list';

    angular.module(moduleName)
        .service('claTaskSectionService', projectTaskListService);

    projectTaskListService.$inject = ['$http'];

    function projectTaskListService($http)
    {
        var service = this;

        service.get = function (project_id) {
            return $http.get('/api/projects/v3/' + project_id +'/sections', {})
                .then(function (response) {
                    return response.data;
                }, function (err) {
                    console.error('Request failed', err);
                });
        }
    }
}());
