<?php
namespace Claromentis\Projects\Controller;

$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array("_f11369824f533e8" . "206f9ccc0c9aab3a" . "0" => base64_decode("bGl" . "taX" . "Q="), "_0290d5279a73376ebff811c191d735" . "a6" => base64_decode("c29ydF9ka" . "XI="), "_f6a16426f3" . "b3f03ad6bac" . "ec912eec291" => base64_decode("c29ydA=" . "="), "_a71dc9333bd8ad9" . "5d55d6624b477875" . "f" => base64_decode("ZGF0" . "YQ=="), "_7af8fa1543a4f2c3d" . "3e6350f7f0c4fcd" => base64_decode("YXN" . "j"), "_ea8229a121" . "285ee649a72" . "fd880bac39b" => base64_decode("YXJyYXlfZmlsdGV" . "y"), "_8ab6ddf42088608c501fcded8" . "995e76c" => base64_decode("IA=" . "="), "_18c93a32ba5faf9509389a94787e679" . "8" => base64_decode("bW9kaWZp" . "ZWQ="), "_4d707fab93bebb00bbe69" . "e8159697c90" => base64_decode(""), "_1f50e30" . "be8c2fef" . "a6881834" . "e71d504a" . "2" => base64_decode("b2Zmc2" . "V0"), "_25867e3e3db" . "28969253f3a3" . "70c3166ba" => base64_decode("ZG" . "Vz" . "Yw" . "=="), "_b1767a84b84eaf3919b918b" . "d13dd4fdd" => base64_decode("dG9wa" . "WNfcG" . "lubmV" . "k"), "_f4eafa5f493306ffdb51a6" . "88b21dd507" => base64_decode("dG90YW" . "w="), "_206f063cdbd5801a283704" . "ef0c883699" => base64_decode("a2V5d29" . "yZHM="), "_1bee3d4d1d0df49e0fcf8b9ed2e" . "cb8fa" => base64_decode("ZXhwbG9kZQ" . "=="));
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Http\RequestData;
use Claromentis\Core\Http\StatusCode;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Core\Security\Exception\AccessDeniedException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Projects\Api\TopicApi;
use Claromentis\Projects\Dialog\TopicDialog;
use Claromentis\Projects\Entity\Topic;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\Repository\ProjectRepository;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;




class TopicRestController
{
    
    
    
    
    protected $project_provider;
    
    
    
    
    protected $topic_api;
    
    
    
    
    protected $format;
    
    
    
    
    protected $dialog;
    public function __construct(ProjectRepository $project_repository, TopicApi $topic_api, RestFormatter $format, TopicDialog $dialog)
    {
        $this->project_provider = $project_repository;
        $this->topic_api = $topic_api;
        $this->format = $format;
        $this->dialog = $dialog;
    }
    public function ShowList(PermissionsChecker $permissions_checker, RequestData $request_data, int $project_id)
    {
        $project = $this->project_provider->GetProject($project_id);
        if ($project === null) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIViewAllTopics($permissions_checker)) {
            throw new AccessDeniedException();
        }
        $_f6a16426f3b3f03ad6bacec912eec291 = $request_data->Get($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_f6a16426" . "f3b3f03ad" . "6bacec912" . "eec291"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_18c93a32ba5faf9509389a9" . "4787e6798"]);
        $_0290d5279a73376ebff811c191d735a6 = $request_data->Get($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_0290d5279a73376ebff811c" . "191d735a6"], $_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_18c93a32ba5faf9509389a94787" . "e6798"] ? $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_25867e3e3" . "db28969253" . "f3a370c316" . "6ba"] : $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_7af8fa1543a4f2c3d3e6350f" . "7f0c4fcd"]);
        $_206f063cdbd5801a283704ef0c883699 = $this->GetKeywords($request_data);
        $_e14537bb3cca32e664b153d5ceb1ef47 = $this->topic_api->GetTopics($project_id, $_f6a16426f3b3f03ad6bacec912eec291, $_0290d5279a73376ebff811c191d735a6, $request_data->Get($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_f11369824f533e8206f9ccc0c9a" . "ab3a0"], 20), $request_data->Get($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_1f50e30be" . "8c2fefa688" . "1834e71d50" . "4a2"], 0), $_206f063cdbd5801a283704ef0c883699);
        $_f4eafa5f493306ffdb51a688b21dd507 = $this->topic_api->CountTopics($project_id, $_206f063cdbd5801a283704ef0c883699);
        $_cfcf180dac4148ce727d28c28880806e = [];
        foreach ($_e14537bb3cca32e664b153d5ceb1ef47 as $topic) {
            $_cfcf180dac4148ce727d28c28880806e[] = $this->dialog->ShowJson($topic);
        }
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_a71dc9333bd8ad95d" . "55d6624b477875f"] => $_cfcf180dac4148ce727d28c28880806e, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_f4eafa5f493306ffdb51a688b21dd50" . "7"] => $_f4eafa5f493306ffdb51a688b21dd507]);
    }
    public function Show(PermissionsChecker $permissions_checker, Topic $topic, int $project_id)
    {
        $project = $this->project_provider->GetProject($topic->project_id);
        if ($topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIViewTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        return new JsonPrettyResponse($this->dialog->ShowJson($topic));
    }
    public function Update(PermissionsChecker $permissions_checker, int $project_id, Topic $topic, SecurityContext $context, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6)
    {
        $_231341bedbbeea0ba9fa8da63ef63dc1 = !$topic->id;
        $project = $this->project_provider->GetProject($project_id);
        if ($topic->project_id && $topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIEditTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->format->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_0918e1b00a3c23a7eb313ecb5b7471a1 = $this->dialog->TopicDataFromJson($_ed5f03d686c37933b5943f295c6b4a43, $context, $project_id);
        if (isset($_0918e1b00a3c23a7eb313ecb5b7471a1[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_b1767a84b84eaf3919b918bd" . "13dd4fdd"]]) && !$project->CanIPinTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $this->topic_api->Update($topic, $_0918e1b00a3c23a7eb313ecb5b7471a1);
        return new JsonPrettyResponse($this->dialog->ShowJson($topic), $_231341bedbbeea0ba9fa8da63ef63dc1 ? StatusCode::CREATED : StatusCode::OK);
    }
    public function Delete(PermissionsChecker $permissions_checker, int $project_id, Topic $topic)
    {
        $project = $this->project_provider->GetProject($project_id);
        if ($topic->project_id && $topic->project_id !== $project_id) {
            throw new NotFoundHttpException();
        }
        if (!$project->CanIEditTopic($permissions_checker, $topic)) {
            throw new AccessDeniedException();
        }
        $this->topic_api->Delete($topic);
        return new JsonPrettyResponse($this->dialog->ShowJson($topic));
    }
    protected function GetKeywords(RequestData $request_data)
    {
        $_028f0444215be3fb127b022ccc085771 = $request_data->Get($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_206f063c" . "dbd5801a2" . "83704ef0c" . "883699"], $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_4d707fab93bebb00bbe69e8159697c" . "90"]);
        if (empty($_028f0444215be3fb127b022ccc085771)) {
            return [];
        }
        return $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_ea8229a121285ee649a72fd880bac" . "39b"]($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_1bee3d4d1d0df49e" . "0fcf8b9ed2ecb8fa"]($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8ab6ddf420886" . "08c501fcded899" . "5e76c"], $_028f0444215be3fb127b022ccc085771));
    }
}