var angular = require('cla_angular');
window.angular = angular;

require('./projects.libs.js');
require('comments');
require('user_picker');
require('ng.cla.core.html_editor');
require('ng.cla.core.breadcrumb');
require('ng.cla.core.lmsg');
require('ng.cla.core.growl');
require('./lib/ng-sortable.js');
require('user_picker');
require('datatable');

require('./projects.tasks_util');

angular.module('claromentis.project', []);
require('directive/colourPicker.js');
require('directive/datePicker.js');


// services
angular.module('cla.service.project_details', []);
require('./service/projectDetails.service');

angular.module('cla.service.project_task_list', []);
require('./service/projectTaskList.service');
require('./service/history.service.js');

// Other modules
require('./ng/modules/widgets/projects_widgets.module.js');
require('./ng/modules/project/header_buttons/header_buttons.module.js');

function sanitizeFilter($sce)
{
    return function(htmlCode)
    {
        return $sce.trustAsHtml(htmlCode);
    }
}

angular.module(
    'projectDetailApp',
    [
        'ui.bootstrap', 'ui.sortable', 'ngResource', 'angularUtils.directives.dirPagination', 'claromentis.project',
        'commentsModule', 'cla.core.lmsg', 'cla.core.breadcrumb', 'cla.core.growl', 'cla.core.datatable', 'cla.core.html_editor',
        'topicsPreloadModule', 'cla.service.project_details', 'claromentis.projects.widgets',
        'claromentis.project.tasks_util'
    ]
).filter("sanitize", ['$sce', sanitizeFilter]);

require('./model/projectTaskSectionModel.js');

require('./controller/projectDetailCtrl.js');
require('./controller/projectTasksCtrl.js');
require('./controller/projectTeamCtrl.js');
require('./controller/projectFilesCtrl.js');
require('./controller/historyCtrl.js');

require('./directive/history_changes.directive.js');
require('./directive/history_user.directive.js');
require('./directive/history_priority.directive.js');
require('./directive/history_is_private.directive.js');
require('./directive/history_status.directive.js');
require('./directive/history_list.directive.js');

require('./project/tasks.permission_checker.class.js');

require('./project/tasks.service.js');
require('./project/tasks.list_type.directive.js');
require('./project/tasks.directive.js');

require('./project/tasks_board.directive.js');
require('./project/tasks_board_section.directive.js');
require('./project/tasks_board_status_header.directive.js');
require('./project/tasks_board_status.directive.js');
require('./project/tasks_list.directive.js');

require('./directive/topics_table.directive.js');

require('./directive/nav_tabs');

require('./task/taskEdit.directive.js');
require('./task/taskAddButton.directive.js');
require('./task/taskEdit.service.js');

require('../../js/kolorpicker/style/kolorpicker.css');

module.exports = null;
