<?php
namespace Claromentis\Projects\Controller\Rest\V4\Projects;

$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"] ?: array()) + array("_d6e97f1338ca846ad31" . "366ff22c325aa" => base64_decode("Zmxv" . "b3I="), "_f4afc0b7f4289969aa2dc510" . "0728731f" => base64_decode("cHJvamVjdHMu" . "cmVzdC5ub19w" . "cm9qZWN0"), "_3efc5ba7bf51ca70907f5e65ab602ec" . "1" => base64_decode("SW50ZXJuYWwgU2" . "VydmVyIEVycm9y"), "_1f50e30be8c2fefa688183" . "4e71d504a2" => base64_decode("b2" . "Zm" . "c2" . "V0"), "_54b269a12af880b045f" . "6712e6f865462" => base64_decode("c3R" . "hdH" . "Vz"), "_feb9037589181bc30" . "fa0f1cf78b9f056" => base64_decode("dGl0bG" . "U="), "_61a56c7661858647cd6edb029fbc61" . "24" => base64_decode("RXJyb3Igb2NjdXJl" . "ZCB3aGlsZSByZXRy" . "aWV2aW5nIHByb2pl" . "Y3QgKElkOiA="), "_f11369824f533e8206f" . "9ccc0c9aab3a0" => base64_decode("bGlt" . "aXQ="), "_dadf790ba" . "f241afac94" . "2824c1e6e3" . "7c4" => base64_decode("dHlwZQ" . "=="), "us" . "er" . "_i" . "d" => base64_decode("dXNlc" . "l9pZA" . "=="), "_0284d38f97f9e8b9c" . "7b03bb8928afae1" => base64_decode("KQ" . "=="), "_38f12d8b8c719a8ce0f" . "c2faefc225f35" => base64_decode("YXJyYXlfbWF" . "w"));
use Claromentis\Core\Http\ResponseFactory;
use Claromentis\Core\Http\StatusCode;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Repository\UserRepository;
use Claromentis\Projects\Exceptions\ProjectException;
use Claromentis\Projects\Exceptions\TaskSectionException;
use Claromentis\Projects\Format\ProjectFormatter;
use Claromentis\Projects\Format\ProjectMemberFormatter;
use Claromentis\Projects\Format\TaskFormatter;
use Claromentis\Projects\Format\TaskSectionFormatter;
use Claromentis\Projects\Model\Member;
use Claromentis\Projects\Permissions;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\ProjectApi;
use Claromentis\Projects\Repository\TaskRepository;
use Claromentis\Projects\Repository\TeamRepository;
use Claromentis\Projects\Service\HistoryService;
use Claromentis\Projects\Service\PaginationValidator;
use Claromentis\Projects\TaskListFilter;
use Exception;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Log\LoggerAwareTrait;
use RestExError;
use Symfony\Component\HttpFoundation\Response;
class Controller
{
    use LoggerAwareTrait;
    public const TYPE_STRING = 'https://developer.claromentis.com';
    private ProjectApi $projectApi;
    private RestFormatter $restFormatter;
    private ProjectFormatter $projectFormatter;
    private TaskSectionFormatter $taskSecetionFormatter;
    private ProjectMemberFormatter $projectMemberFormatter;
    private ResponseFactory $response;
    private Lmsg $lmsg;
    private PaginationValidator $paginationValidator;
    
    
    
    
    
    
    
    
    
    
    
    public function __construct(ProjectApi $projectApi, RestFormatter $restFormatter, ProjectFormatter $projectFormatter, TaskSectionFormatter $taskSectionFormatter, ProjectMemberFormatter $projectMemberFormatter, ResponseFactory $responseFactory, Lmsg $lmsg, PaginationValidator $paginationValidator)
    {
        $this->projectApi = $projectApi;
        $this->restFormatter = $restFormatter;
        $this->projectFormatter = $projectFormatter;
        $this->projectMemberFormatter = $projectMemberFormatter;
        $this->taskSecetionFormatter = $taskSectionFormatter;
        $this->response = $responseFactory;
        $this->lmsg = $lmsg;
        $this->paginationValidator = $paginationValidator;
    }
    
    
    
    
    
    public function GetProjects(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof Response) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f11369824f533e8206f9ccc0" . "c9aab3a0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_1f50e30be8c2fefa6881834" . "e71d504a2"]]];
        $_68680c984182bf7876b2bb0ab77ebe01 = $this->projectApi->GetProjects($_1f50e30be8c2fefa6881834e71d504a2, $_f11369824f533e8206f9ccc0c9aab3a0);
        $_7dd4f691d21ad1421df1707157936bcb = $this->projectApi->GetProjectCount();
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $this->projectFormatter->ConvertProjectsToArray($_68680c984182bf7876b2bb0ab77ebe01), [], $_7dd4f691d21ad1421df1707157936bcb));
    }
    
    
    
    
    
    
    
    
    
    public function GetHistory(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, PermissionsChecker $permissionsChecker, HistoryService $historyService, SecurityContext $context, int $project_id) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof Response) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_f11369824f53" . "3e8206f9ccc0c" . "9aab3a0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_1f50e30be8c2fefa6881" . "834e71d504a2"]]];
        $_b4af1f7aa1ccde1a449e9d8afe15b753 = $historyService->GetHistoryItems(Permissions::PROJECT_AGGREGATION, $project_id, $context->GetUserId(), $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_d6e97f1338ca846ad3136" . "6ff22c325aa"]($_1f50e30be8c2fefa6881834e71d504a2 / $_f11369824f533e8206f9ccc0c9aab3a0), $permissionsChecker->CanI($project_id, Permissions::VIEW_ALL_TASKS), $_f11369824f533e8206f9ccc0c9aab3a0);
        $_f4eafa5f493306ffdb51a688b21dd507 = $historyService->GetHistoryItemCount(Permissions::PROJECT_AGGREGATION, $project_id, $context->GetUserId(), $permissionsChecker->CanI($project_id, Permissions::VIEW_ALL_TASKS));
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $_b4af1f7aa1ccde1a449e9d8afe15b753, [], $_f4eafa5f493306ffdb51a688b21dd507));
    }
    
    
    
    
    
    
    
    
    public function GetMembers(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, TeamRepository $teamRepository, UserRepository $userRepository, int $project_id) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof Response) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f11369824f533e8206f9c" . "cc0c9aab3a0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_1f50e30be8c2fefa68" . "81834e71d504a2"]]];
        $_d4bb413635fdb674c537e86e87154690 = $teamRepository->GetProjectTeamMemberBatch($project_id, $_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2);
        $_e4543e131c67c631b14751cc849d1310 = $userRepository->find($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_38f12d8b8c719a8" . "ce0fc2faefc225f3" . "5"](function (Member $_a35dab1038a75763ebdb4c72b9c7d59a) {
            return $_a35dab1038a75763ebdb4c72b9c7d59a->GetProperty($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["user_" . "id"]);
        }, $_d4bb413635fdb674c537e86e87154690))->getDictionary();
        $_f4eafa5f493306ffdb51a688b21dd507 = (int) $teamRepository->GetProjectTeamTotal($project_id);
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $this->projectMemberFormatter->ConvertMembersToArray($project_id, $_e4543e131c67c631b14751cc849d1310, $_d4bb413635fdb674c537e86e87154690), [], $_f4eafa5f493306ffdb51a688b21dd507));
    }
    
    
    
    
    
    
    public function GetProjectSection(int $project_id, int $section_id) : Response
    {
        try {
            $_758fa36b832c1bf88d017782079d032b = $this->projectApi->GetProjectTaskSection($section_id);
        } catch (TaskSectionException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_dadf790baf241" . "afac942824c1e6" . "e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_feb9037589181bc30fa0f1cf7" . "8b9f056"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_f4afc0b7f4289969aa2dc5" . "100728731f"]), $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_54b269a12af88" . "0b045f6712e6f8" . "65462"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        }
        return $this->response->GetJsonPrettyResponse($this->taskSecetionFormatter->ConvertTaskSectionToArray($_758fa36b832c1bf88d017782079d032b));
    }
    
    
    
    
    
    public function GetProjectSections(int $project_id) : Response
    {
        try {
            $project = $this->projectApi->GetProject($project_id);
            $_24a1eeb316ff169c1b972124d295b6bd = $this->projectApi->GetProjectTaskSections($project);
        } catch (ProjectException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_dadf790baf241afac" . "942824c1e6e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_feb9037589181bc3" . "0fa0f1cf78b9f056"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_f4afc0b" . "7f428996" . "9aa2dc51" . "00728731" . "f"]), $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_54b269a12af880b045f6712e6" . "f865462"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        } catch (Exception $_c35473364fa7a050299058f332ec29c1) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_61a56c766185" . "8647cd6edb029" . "fbc6124"] . $project_id . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_0284d38f97f9e8b9c7" . "b03bb8928afae1"], [$_c35473364fa7a050299058f332ec29c1]);
            throw new RestExError($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_3efc5ba7bf51ca70907f5e65ab" . "602ec1"], StatusCode::INTERNAL_SERVER_ERROR, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_3efc5ba7bf51ca70907f5e65ab60" . "2ec1"], $_c35473364fa7a050299058f332ec29c1);
        }
        return $this->response->GetJsonPrettyResponse($this->taskSecetionFormatter->ConvertTaskSectionsToArray($_24a1eeb316ff169c1b972124d295b6bd));
    }
    
    
    
    
    
    public function GetProject(int $project_id) : Response
    {
        try {
            $project = $this->projectApi->GetProject($project_id);
        } catch (ProjectException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_dadf790baf241afac94282" . "4c1e6e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_feb9037589181bc30fa0f1cf78b9f05" . "6"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_f4afc0b7f4289969aa2dc51007" . "28731f"]), $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_54b269a12af880b045f67" . "12e6f865462"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        } catch (Exception $_c35473364fa7a050299058f332ec29c1) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_61a56c7661858647cd6edb029fbc6" . "124"] . $project_id . $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_0284d38f97f9e8b9c7b0" . "3bb8928afae1"], [$_c35473364fa7a050299058f332ec29c1]);
            throw new RestExError($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_3efc5ba7bf51ca70907f5e6" . "5ab602ec1"], StatusCode::INTERNAL_SERVER_ERROR, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_3efc5ba7bf51ca70907f5e65a" . "b602ec1"], $_c35473364fa7a050299058f332ec29c1);
        }
        return $this->response->GetJsonPrettyResponse($this->projectFormatter->ConvertProjectToArray($project));
    }
    
    
    
    
    
    
    
    
    
    
    public function GetTasks(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, TaskFormatter $taskFormatter, SecurityContext $context, TaskRepository $taskRepository, int $project_id) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof Response) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_f1136982" . "4f533e820" . "6f9ccc0c9" . "aab3a0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_1f50e30be8c2fefa6881834e71d5" . "04a2"]]];
        $_4a1764abe800e52e29d3040099309451 = new TaskListFilter();
        $_4a1764abe800e52e29d3040099309451->SetLimit($_f11369824f533e8206f9ccc0c9aab3a0);
        $_4a1764abe800e52e29d3040099309451->SetOffset($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d6e97f1338ca846ad3" . "1366ff22c325aa"]($_1f50e30be8c2fefa6881834e71d504a2 / $_f11369824f533e8206f9ccc0c9aab3a0));
        $_4a1764abe800e52e29d3040099309451->SetProjectIds([$project_id]);
        $_5a41aa961f592408a9a61999dd5e8716 = $taskRepository->GetTasks($_4a1764abe800e52e29d3040099309451, $context);
        $_f4eafa5f493306ffdb51a688b21dd507 = $taskRepository->GetTaskCount($_4a1764abe800e52e29d3040099309451, $context);
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $taskFormatter->ConvertTasksToArray($_5a41aa961f592408a9a61999dd5e8716), [], $_f4eafa5f493306ffdb51a688b21dd507));
    }
}