<?php
namespace Claromentis\Projects\Controller\Rest\V4\Tasks;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] = (@$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] ?: array()) + array("_f11369824f" . "533e8206f9c" . "cc0c9aab3a0" => base64_decode("bGltaXQ" . "="), "_f4afc0b7f4289969aa2dc5100728" . "731f" => base64_decode("cHJvamVjdHMucmVzdC5ub19wcm9qZ" . "WN0"), "_54b269a12af8" . "80b045f6712e6" . "f865462" => base64_decode("c3" . "Rh" . "dH" . "Vz"), "_b8b74f8815261bad32f7c6ae658b4cb" . "9" => base64_decode("cHJvamVjdHMucmV" . "zdC5ub190YXNr"), "_1f50e30be8" . "c2fefa68818" . "34e71d504a2" => base64_decode("b2Z" . "mc2" . "V0"), "_d6e97f133" . "8ca846ad31" . "366ff22c32" . "5aa" => base64_decode("Zmxvb3I" . "="), "_dadf790baf241afac942824c1e" . "6e37c4" => base64_decode("dHlwZ" . "Q=="), "_feb9037589181bc30f" . "a0f1cf78b9f056" => base64_decode("dGl0b" . "GU="));
use Claromentis\Core\Http\ResponseFactory;
use Claromentis\Core\Http\StatusCode;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Projects\Format\TaskFormatter;
use Claromentis\Projects\Permissions;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\Repository\TaskRepository;
use Claromentis\Projects\Service\HistoryService;
use Claromentis\Projects\Service\PaginationValidator;
use Claromentis\Projects\TaskListFilter;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
class Controller
{
    const TYPE_STRING = 'https://developer.claromentis.com';
    private ResponseFactory $response;
    private Lmsg $lmsg;
    private TaskRepository $taskRepository;
    private TaskFormatter $taskFormatter;
    private HistoryService $historyService;
    private PermissionsChecker $permissionsChecker;
    private RestFormatter $restFormatter;
    private PaginationValidator $paginationValidator;
    
    
    
    
    
    
    
    
    
    
    
    public function __construct(ResponseFactory $responseFactory, Lmsg $lmsg, TaskRepository $taskRepository, TaskFormatter $taskFormatter, HistoryService $historyService, PermissionsChecker $permissionsChecker, RestFormatter $restFormatter, PaginationValidator $paginationValidator)
    {
        $this->response = $responseFactory;
        $this->lmsg = $lmsg;
        $this->taskRepository = $taskRepository;
        $this->taskFormatter = $taskFormatter;
        $this->historyService = $historyService;
        $this->permissionsChecker = $permissionsChecker;
        $this->restFormatter = $restFormatter;
        $this->paginationValidator = $paginationValidator;
    }
    
    
    
    
    
    
    
    
    
    
    public function GetTasks(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, TaskFormatter $taskFormatter, SecurityContext $context, ProjectRepository $projectRepository, TaskRepository $taskRepository) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof JsonResponse) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_f113698" . "24f533e8" . "206f9ccc" . "0c9aab3a" . "0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_1f50e30be8c2fefa6881834e71d50" . "4a2"]]];
        $_4a1764abe800e52e29d3040099309451 = new TaskListFilter();
        $_4a1764abe800e52e29d3040099309451->SetLimit($_f11369824f533e8206f9ccc0c9aab3a0);
        $_4a1764abe800e52e29d3040099309451->SetOffset($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_d6e97f1338ca846ad" . "31366ff22c325aa"]($_1f50e30be8c2fefa6881834e71d504a2 / $_f11369824f533e8206f9ccc0c9aab3a0));
        $_4a1764abe800e52e29d3040099309451->SetProjectIds($projectRepository->GetMyProjects());
        $_5a41aa961f592408a9a61999dd5e8716 = $taskRepository->GetTasks($_4a1764abe800e52e29d3040099309451, $context);
        $_f4eafa5f493306ffdb51a688b21dd507 = $taskRepository->GetTaskCount($_4a1764abe800e52e29d3040099309451, $context);
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $taskFormatter->ConvertTasksToArray($_5a41aa961f592408a9a61999dd5e8716), [], $_f4eafa5f493306ffdb51a688b21dd507));
    }
    
    
    
    
    
    
    public function GetTask(int $task_id, SecurityContext $context) : Response
    {
        $_696b535739055ed7d827709916d07dea = $this->taskRepository->LoadTask($task_id, $context);
        if (!$_696b535739055ed7d827709916d07dea) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_dadf790baf2" . "41afac942824" . "c1e6e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_feb9037589181bc30fa0f1cf" . "78b9f056"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_b8b74f8815261bad32f7c6ae" . "658b4cb9"]), $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_54b269a12af880b045f6" . "712e6f865462"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        }
        return $this->response->GetJsonPrettyResponse($this->taskFormatter->ConvertTaskToArray($_696b535739055ed7d827709916d07dea));
    }
    
    
    
    
    
    
    
    public function GetHistory(ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, SecurityContext $context, int $task_id) : Response
    {
        $_4c4d12d3e4f6cac68e3eecffe9887915 = $this->paginationValidator->validate($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if ($_4c4d12d3e4f6cac68e3eecffe9887915 instanceof JsonResponse) {
            return $_4c4d12d3e4f6cac68e3eecffe9887915;
        }
        [$_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2] = [$_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_f11369824f533e8206f9cc" . "c0c9aab3a0"]], $_4c4d12d3e4f6cac68e3eecffe9887915[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_1f50e30be8c2fefa6881834" . "e71d504a2"]]];
        $_696b535739055ed7d827709916d07dea = $this->taskRepository->LoadTask($task_id);
        if (!$_696b535739055ed7d827709916d07dea) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_dadf790baf241afac" . "942824c1e6e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_feb9037589181bc30fa0f" . "1cf78b9f056"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_f4afc0b7f4289969aa2dc510" . "0728731f"]), $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_54b269a" . "12af880b" . "045f6712" . "e6f86546" . "2"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        }
        $_47d202493f86e587c8454fae73657c90 = $_696b535739055ed7d827709916d07dea->GetProject();
        $_f4eafa5f493306ffdb51a688b21dd507 = $this->historyService->GetHistoryItemCount(Permissions::TASK_AGGREGATION, $task_id, $context->GetUserId(), $this->permissionsChecker->CanI($_47d202493f86e587c8454fae73657c90, Permissions::VIEW_ALL_TASKS));
        $_a71dc9333bd8ad95d55d6624b477875f = $this->historyService->GetHistoryItems(Permissions::TASK_AGGREGATION, $task_id, $context->GetUserId(), $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_d6e97f1338ca846ad313" . "66ff22c325aa"]($_1f50e30be8c2fefa6881834e71d504a2 / $_f11369824f533e8206f9ccc0c9aab3a0), $this->permissionsChecker->CanI($_47d202493f86e587c8454fae73657c90, Permissions::VIEW_ALL_TASKS), $_f11369824f533e8206f9ccc0c9aab3a0);
        return $this->response->GetJsonPrettyResponse($this->restFormatter->Paginate($_b791059c94b285cdf1c90ca6f3a8f2a6, $_a71dc9333bd8ad95d55d6624b477875f, [], $_f4eafa5f493306ffdb51a688b21dd507));
    }
}