<?php
namespace Claromentis\Projects\Controller\Rest\V4\Tasks\Status;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"] ?: array()) + array("sta" . "tus" => base64_decode("c3Rh" . "dHVz"), "_dadf790baf" . "241afac9428" . "24c1e6e37c4" => base64_decode("dHlwZ" . "Q=="), "_feb9037589181bc30fa0f1cf78b9f0" . "56" => base64_decode("dGl0bGU" . "="), "_f4afc0b7f4289969aa2dc5100728731" . "f" => base64_decode("cHJvamVjdHMucmVzdC5ub19w" . "cm9qZWN0"));
use Claromentis\Core\Http\ResponseFactory;
use Claromentis\Core\Http\StatusCode;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Projects\Entity\TaskStatus;
use Claromentis\Projects\Format\TaskStatusFormatter;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\TaskStatusApi;
use Symfony\Component\HttpFoundation\Response;
class Controller
{
    const TYPE_STRING = 'https://developer.claromentis.com';
    private ResponseFactory $response;
    private ProjectRepository $projectRepository;
    private Lmsg $lmsg;
    private TaskStatusApi $taskStatusApi;
    private TaskStatusFormatter $taskStatusFormatter;
    
    
    
    
    
    
    
    
    public function __construct(Lmsg $lmsg, ResponseFactory $responseFactory, ProjectRepository $projectRepository, TaskStatusApi $taskStatusApi, TaskStatusFormatter $taskStatusFormatter)
    {
        $this->response = $responseFactory;
        $this->projectRepository = $projectRepository;
        $this->lmsg = $lmsg;
        $this->taskStatusApi = $taskStatusApi;
        $this->taskStatusFormatter = $taskStatusFormatter;
    }
    
    
    
    
    
    public function GetList(int $project_id) : Response
    {
        $project = $this->projectRepository->GetProject($project_id);
        if (!$project) {
            $_a71dc9333bd8ad95d55d6624b477875f = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_dadf790baf241afac" . "942824c1e6e37c4"] => self::TYPE_STRING, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_feb9037589181bc" . "30fa0f1cf78b9f05" . "6"] => ($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f4afc0b7f4289969aa2dc51" . "00728731f"]), $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["stat" . "us"] => StatusCode::NOT_FOUND];
            return $this->response->GetJsonPrettyResponse($_a71dc9333bd8ad95d55d6624b477875f, StatusCode::NOT_FOUND);
        }
        $_354ade7121deb022b926fb0c68fd259c = $this->taskStatusApi->getProjectStatuses($project)->all();
        return $this->response->GetJsonPrettyResponse($this->taskStatusFormatter->ConvertTaskStatusesToArray($_354ade7121deb022b926fb0c68fd259c));
    }
    
    
    
    
    
    public function GetTaskStatus(TaskStatus $status) : Response
    {
        return $this->response->GetJsonPrettyResponse($this->taskStatusFormatter->ConvertTaskStatusToArray($status));
    }
}