define(['./topics.component.html'], function (template)
{
    var Topics = {
        bindings: {
            projectId: '@',
            id: '@'
        },
        templateUrl: template,
        controller: [
            '$element',
            'topicsOverviewPreloadFactory',
            'userListService',
            function ($element, topicsPreload, userListService) {
                const DISPLAYED_USER_COUNT = 3;

                var ctrl = this;

                ctrl.topics = [];

                ctrl.$onInit = function() {
                    ctrl.load(topicsPreload);
                };

                ctrl.load = function(data) {
                    ctrl.topics.length = 0;
                    for (var topicsIndex = 0; topicsIndex < data.topics.length; topicsIndex++)
                    {
                        var topic = data.topics[topicsIndex];
                        topic.displayedUsers = [];

                        for (var userIndex = 0; userIndex < DISPLAYED_USER_COUNT; userIndex++)
                        {
                            if (topic.users[userIndex] !== undefined)
                                topic.displayedUsers.push(topic.users[userIndex]);
                        }

                        ctrl.topics.push(topic);
                    }
                };

                ctrl.getAdditionalUserCount = function(topic) {
                    if (topic.users.length <= DISPLAYED_USER_COUNT)
                        return 0;

                    return topic.users.length - DISPLAYED_USER_COUNT;
                };

                ctrl.showAdditionalUsers = function(topic) {
                    userListService.showUsersList(topic.users);
                };
            }
        ]
    };

    return Topics;
});
