(function()
{
	var moduleName = 'projectEditApp';

	angular.module(moduleName)
		.controller("projectEditCtrl", ["$scope", "$http", 'breadcrumb.service', projectEditController]);

	function projectEditController($scope, $http, breadcrumbService)
	{
		$scope.project = project.info;
		$scope.company_options = project.info.companies;
		$scope.company = 0;

		$scope.roleData = [];
        $scope.rightData = [];

        $scope.stageTwoBegun = false;

		// Go to the right tab
		var tab = window.location.hash;
		if (tab.length > 0)
		{
			tab = tab.substr(2);

			if (angular.element('#' + tab).length > 0)
            {
                angular.element('#top-tab-content > .nav-item > .active').removeClass('active');
                angular.element('#top-tab-list > .nav-item > .active').removeClass('active');
                angular.element('#' + tab).addClass('active');
                angular.element('#' + tab + 'Tab > .nav-link').addClass('active');

                // set activeTab in local storage to override value if previously set when on another tab
                localStorage.setItem('activeTab', tab);
            }
		}

		// The description text can't be set from the template as it will be rendered after the
		// BBCode component and show BBCode markup in the WYSIWYG view
		angular.element('#projectDescription').val($scope.project.description);

		var breadcrumb =
		[
			{
				'url': '/projects',
				'name': lmsg('projects.breadcrumb.projects')
			}
		];

		if ($scope.project.id > 0)
		{
			breadcrumb.push(
			{
				'url': '/projects/' + $scope.project.id,
				'name': $scope.project.name
			});
			breadcrumb.push(
			{
				'url': '',
				'name': lmsg('projects.breadcrumb.edit_project')
			});
		} else
		{
			breadcrumb.push(
			{
				'url': '',
				'name': lmsg('projects.breadcrumb.add_project')
			});
		}
		breadcrumbService.setCrumbs(breadcrumb);

		for (var i = 0; i < $scope.company_options.length; i++)
		{
			if ($scope.company_options[i].value == project.info.company_id)
			{
				$scope.company = $scope.company_options[i];
			}
		}

		if ($scope.company == 0)
			$scope.company = $scope.company_options[0];

		$scope.status = project.info.status;
		$scope.duration = project.info.duration_units;
		$scope.duration_other = '';
		$scope.duration_other_name = lmsg('projects.duration.other');

		if (($scope.duration != lmsg('projects.duration.hours')) &&
			($scope.duration != lmsg('projects.duration.days')))
		{
			$scope.duration_other = $scope.duration;
			$scope.duration = lmsg('projects.duration.other');
		}

		$scope.rolesInit = function(roles, rights, is_edit)
        {
            $scope.roleData.length = 0;
            $scope.roleData.options = roles.options;
            $scope.roleData.roles = roles.roles;
            $scope.rightData.rights = rights.rights;
            $scope.rightData.rightGroups = rights.right_groups;
            $scope.stageTwoBegun = !!is_edit;
        };

		$scope.confirmDelete = function(event, project_id)
		{
			event.preventDefault();

			if(confirm(lmsg('projects.js.are_you_sure')))
			{
				var url = '/api/projects/' + project_id;
				$http.delete(url).then(function(result)
				{
					if (result.data.result)
						window.location.href = '/projects?message=' + encodeURIComponent(lmsg('projects.js.project.project_deleted'));
					else
						cla.showMessage(lmsg('common.general.error') + ': ' + result.data.message, '', true);
				});
			}
		};

		$scope.onTabClick = function(tabName)
		{
		    if (tabName === "tabRolesRights")
                $scope.stageTwoBegun = true;

			window.location.hash = '/' + tabName;
		};

		$scope.onContinueClick = function(e) {
			e.preventDefault();
			$scope.stageTwoBegun = true;

            angular.element('.nav-pills a[href="#tabRolesRights"]').trigger('click');

			// jump to the top of the project edit dialog, so that the help text is visible
			var top = angular.element("#projectEditApp").prop("offsetTop");
			window.scrollTo(0, top);
		}
	}
}());
