<?php
$_db_migration_to = '10.02'; // 3.0.2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_task_indexes_again.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$logger = $migrations->getLogger();

try {
	$db->CreateIndex('projects_task', 'projects_task_assignee', 'assignee');
	$db->CreateIndex('projects_task', 'projects_task_project_id', 'project_id');
} catch (\Throwable $throwable) {
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

$logger->notice("If you see warnings regarding already existing indexes (duplicate key name), this is not a problem!");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('10.02');
