<?php
namespace Claromentis\Projects\Comments;

$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array("_ea1692ad3e489cd15" . "4cba56f652caca3" => base64_decode("cHJvamVjdHMucGVybWl" . "zc2lvbnNfY2hlY2tlcg" . "=="));
use Claromentis\Comments\CommentableInterface;
use Claromentis\Comments\CommentLocationInterface;
use Claromentis\Comments\CommentUserPermissionsInterface;
use Claromentis\Comments\Model\Comment;
use Claromentis\Comments\Notification\Notification;
use Claromentis\Comments\Rights;
use Claromentis\Comments\SupportedOptions;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Core\Services;
use Claromentis\Projects\Entity\Topic;
use Claromentis\Projects\Model\Project;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\ProjectsBreadcrumbGenerator;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\Repository\TopicRepository;
use Claromentis\Projects\Service\NotificationService;
class CommentableTopic implements CommentableInterface, CommentLocationInterface, CommentUserPermissionsInterface
{
    
    
    
    
    private $topic;
    
    
    
    
    private $project;
    
    
    
    
    private $notification_service;
    
    
    
    
    private $breadcrumb;
    public function __construct()
    {
        $this->notification_service = Services::I()->{NotificationService::class};
        $this->breadcrumb = Services::I()->{ProjectsBreadcrumbGenerator::class};
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetBreadcrumbs(int $_2d876b122533fac9677b16ea6c640aa6)
    {
        return $this->breadcrumb->ViewTopic($this->project, $this->topic);
    }
    
    
    
    
    
    
    
    public function Load($_0ea4e32b57963ac0cb3057e03e9aef64, $_4a033bdf0ce701c6255d5238633ab2d0 = [])
    {
        
        
        $_76eecf99a8fa017451baf171d6a95d69 = Services::I()->{TopicRepository::class};
        
        
        $_fad86c984731e0344693ab9998c0e8f1 = Services::I()->{ProjectRepository::class};
        $this->topic = $_76eecf99a8fa017451baf171d6a95d69->find($_0ea4e32b57963ac0cb3057e03e9aef64);
        $this->project = $_fad86c984731e0344693ab9998c0e8f1->GetProject($this->topic->project_id);
    }
    
    
    
    
    
    
    
    public function GetAggregationObject()
    {
        return $this->topic;
    }
    
    
    
    
    
    
    
    
    public function GetOptions()
    {
        return [SupportedOptions::REPLIES => true, SupportedOptions::LIKES => true, SupportedOptions::ATTACHMENTS => true];
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UserHasPermission(SecurityContext $_0f4808db75324a12fb1768e785daadb7, $_a18f3f2e515f9b634cee4e5fbdcdb572, Comment $_e8d840684607f6c2bbef523090642168 = null)
    {
        
        
        $_7a1d9033e72ef3e12945eb63dd2bf481 = Services::I()->{$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_ea1692a" . "d3e489cd" . "154cba56" . "f652caca" . "3"]};
        
        
        $_0a3f284de65e596869ef47aa9e91f906 = $this->project;
        if (!$_0a3f284de65e596869ef47aa9e91f906->CanIViewComment($_7a1d9033e72ef3e12945eb63dd2bf481)) {
            return false;
        }
        if (($_a18f3f2e515f9b634cee4e5fbdcdb572 & Rights::PERM_ADD) == Rights::PERM_ADD && !$_0a3f284de65e596869ef47aa9e91f906->CanIAddComment($_7a1d9033e72ef3e12945eb63dd2bf481)) {
            return false;
        }
        if (!$_e8d840684607f6c2bbef523090642168) {
            return $this->UserHasPermissionForAllComments($_7a1d9033e72ef3e12945eb63dd2bf481, $_a18f3f2e515f9b634cee4e5fbdcdb572);
        }
        if (($_a18f3f2e515f9b634cee4e5fbdcdb572 & Rights::PERM_EDIT) == Rights::PERM_EDIT && !$_0a3f284de65e596869ef47aa9e91f906->CanIEditComment($_7a1d9033e72ef3e12945eb63dd2bf481, $_e8d840684607f6c2bbef523090642168)) {
            return false;
        }
        if ($_e8d840684607f6c2bbef523090642168 && ($_a18f3f2e515f9b634cee4e5fbdcdb572 & Rights::PERM_DELETE) == Rights::PERM_DELETE && !$_0a3f284de65e596869ef47aa9e91f906->CanIDeleteComment($_7a1d9033e72ef3e12945eb63dd2bf481, $_e8d840684607f6c2bbef523090642168)) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Notify(Comment $_e8d840684607f6c2bbef523090642168, Notification $_0dfb4a13f8c551dff0f061eebc847961)
    {
        $_99aaa03a11622e16e59bff0771ea8ef3 = new ProjectCommentNotification($_e8d840684607f6c2bbef523090642168, $this->notification_service);
        $_0dfb4a13f8c551dff0f061eebc847961->template = $_99aaa03a11622e16e59bff0771ea8ef3->GetTemplate();
        $_0dfb4a13f8c551dff0f061eebc847961->type = $_99aaa03a11622e16e59bff0771ea8ef3->GetType();
        $_0dfb4a13f8c551dff0f061eebc847961->SetTemplateValues($_99aaa03a11622e16e59bff0771ea8ef3->GetMessageParams());
        $_0dfb4a13f8c551dff0f061eebc847961->SetRecipients($_99aaa03a11622e16e59bff0771ea8ef3->GetRecipients());
        $_0dfb4a13f8c551dff0f061eebc847961->Send();
    }
    
    
    
    
    
    
    
    
    protected function UserHasPermissionForAllComments(PermissionsChecker $_7a1d9033e72ef3e12945eb63dd2bf481, $_a18f3f2e515f9b634cee4e5fbdcdb572) : bool
    {
        if (($_a18f3f2e515f9b634cee4e5fbdcdb572 & Rights::PERM_EDIT) == Rights::PERM_EDIT && !$this->project->CanIEditAllTopicComments($_7a1d9033e72ef3e12945eb63dd2bf481, $this->topic)) {
            return false;
        }
        if (($_a18f3f2e515f9b634cee4e5fbdcdb572 & Rights::PERM_DELETE) == Rights::PERM_DELETE && !$this->project->CanIDeleteAllTopicComments($_7a1d9033e72ef3e12945eb63dd2bf481, $this->topic)) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    public function getUsersWithPermission(Comment $_e8d840684607f6c2bbef523090642168, int $_5630a508eaf62fdbab410362fa17735c = Rights::PERM_VIEW) : ?array
    {
        
        
        if ((int) $_e8d840684607f6c2bbef523090642168->aggregation !== Topic::AGGREGATION) {
            return null;
        }
        if ($_5630a508eaf62fdbab410362fa17735c === Rights::PERM_VIEW) {
            $_2856d788496f3470193044aee34d0627 = Services::I()->{PermissionsChecker::class};
            return $_2856d788496f3470193044aee34d0627->GetProjectMembersWithViewTopicsRights($this->project->GetId(), false);
        }
        return [];
    }
}