<?php
namespace Claromentis\Projects\Controller;

$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"] ?: array()) + array("_0ea4e32b57963" . "ac0cb3057e03e9" . "aef64" => base64_decode("aWQ" . "="), "_9ed84d2923d81db75e6" . "348d1b290c051" => base64_decode("Y29tcGxldGVkX3N0Y" . "XR1c19sYWJlbA=="), "_f335946" . "68a14ecd" . "5ede1fb9" . "0b8354c7" . "0" => base64_decode("TmV3IHN0YXR1c" . "yBtdXN0IGhhdm" . "UgbmFtZQ=="), "_80f432640c97e2aa412664" . "c408f72221" => base64_decode("Q2Fubm90IGRlbGV0ZSB" . "pbml0aWFsIHN0YXR1cw" . "=="), "st" . "at" . "us" => base64_decode("c3R" . "hdH" . "Vz"), "_5f4d1ad89c941500471a8370" . "398dad9e" => base64_decode("dG9kb19zdGF0dXNfbGFiZWw" . "="), "_7d5f0a31f61b7b734f21a9bf6acf2" . "502" => base64_decode("Q2Fubm90IGRl" . "bGV0ZSBmaW5h" . "bCBzdGF0dXM="), "_f805302e3f25df291a3d" . "d8ea386da8a4" => base64_decode("IGluIHByb2plY" . "3Qg"), "_8f4004bb39963606d042524caf" . "b2c56e" => base64_decode("Tm8gbmFtZSBnaXZl" . "bg=="), "_a29b27c98290e9" . "26d8b084b48c9ce" . "369" => base64_decode("WW91IGRvIG5vdCBoYXZlIHBlcm1pc3Npb24gdG8gZWRpdCB0aGUgbGlzdCBvZiBzdGF0" . "dXNlcw=="), "_068ab9b9340314c5b07e3" . "e5cc31d925b" => base64_decode("c29y" . "dF9v" . "cmRl" . "cg=="), "_f4afc0b7f4289969aa2dc5" . "100728731f" => base64_decode("cHJvamVjdHMucmVzdC5ub19wc" . "m9qZWN0"), "_8dabb06" . "efc95df4" . "cff7c4af" . "e91857b5" . "3" => base64_decode("bmFtZ" . "Q=="), "_b94c0530a0fc19" . "421865e1efa5f67" . "79f" => base64_decode("Tm8gc3RhdHVzIElE" . "IA=="), "status" . "es" => base64_decode("c3RhdHVzZ" . "XM="), "_4d23892ff91aa3" . "195a85bb548a7f4" . "333" => base64_decode("bG9jYWxpemV" . "kX25hbWU="));
use Analogue\ORM\Exceptions\MappingException;
use Claromentis\Core\CDN;
use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Localization\Lmsg;
use Claromentis\Core\REST\RestFormatter;
use Claromentis\Projects\Entity\TaskStatus;
use Claromentis\Projects\Exceptions\StatusStorageException;
use Claromentis\Projects\Model\Task;
use Claromentis\Projects\Permissions;
use Claromentis\Projects\PermissionsChecker;
use Claromentis\Projects\Repository\ProjectRepository;
use Claromentis\Projects\TaskStatusApi;
use Psr\Http\Message\ServerRequestInterface;
class TaskStatusController
{
    
    
    
    
    protected $api;
    
    
    
    
    protected $project_provider;
    
    
    
    
    protected $formatter;
    
    
    
    
    protected $lmsg;
    public function __construct(TaskStatusApi $api, ProjectRepository $project_provider, RestFormatter $formatter, Lmsg $lmsg)
    {
        $this->api = $api;
        $this->project_provider = $project_provider;
        $this->formatter = $formatter;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    public function ShowList(int $project_id) : JsonPrettyResponse
    {
        $project = $this->project_provider->GetProject($project_id);
        if (!$project) {
            throw new \RestExNotFound(($this->lmsg)($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_f4afc0b7f4289969aa2d" . "c5100728731f"]));
        }
        $statuses = $this->api->getProjectStatuses($project)->all();
        return new JsonPrettyResponse([[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["statu" . "ses"] => $this->FormatStatuses($statuses)]]);
    }
    
    
    
    
    
    
    
    
    
    public function Show(int $project_id, TaskStatus $status) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["stat" . "us"] => $this->FormatStatus($status)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Update(int $project_id, TaskStatus $status, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $_231341bedbbeea0ba9fa8da63ef63dc1 = $status->id === 0;
        $_a71dc9333bd8ad95d55d6624b477875f = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_9bacb470d4f91e74f3caafec23aeca8e = clone $status;
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $status->project_id = $project_id;
            if (empty($_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8dabb06efc95d" . "f4cff7c4afe918" . "57b53"]])) {
                throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_f33594668a14ecd5ede1fb90b83" . "54c70"]);
            }
        }
        $status->sort_order = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_068ab9b9340314c5b07" . "e3e5cc31d925b"]] ?? $status->sort_order;
        $status->name = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_8dabb06efc95df4cff7" . "c4afe91857b53"]] ?? $status->name;
        $this->api->SaveStatus($status);
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $this->api->StatusAddedHistory($status);
        } else {
            $this->api->StatusUpdatedHistory($_9bacb470d4f91e74f3caafec23aeca8e, $status);
        }
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["statu" . "s"] => $this->FormatStatus($status)], $_231341bedbbeea0ba9fa8da63ef63dc1 ? 201 : 200);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateV3(int $project_id, TaskStatus $status, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $_231341bedbbeea0ba9fa8da63ef63dc1 = $status->id === 0;
        $_a71dc9333bd8ad95d55d6624b477875f = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        $_9bacb470d4f91e74f3caafec23aeca8e = clone $status;
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $status->project_id = $project_id;
            if (empty($_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8dabb06efc95df4cff7c4afe9185" . "7b53"]])) {
                throw new \RestExBadRequest($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_f33594668a14ecd5ede1fb" . "90b8354c70"]);
            }
        }
        $status->sort_order = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_068ab9b9340314c5b07e" . "3e5cc31d925b"]] ?? $status->sort_order;
        $status->name = $_a71dc9333bd8ad95d55d6624b477875f[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_8dabb06efc9" . "5df4cff7c4af" . "e91857b53"]] ?? $status->name;
        $this->api->SaveStatus($status);
        if ($_231341bedbbeea0ba9fa8da63ef63dc1) {
            $this->api->StatusAddedHistory($status);
        } else {
            $this->api->StatusUpdatedHistory($_9bacb470d4f91e74f3caafec23aeca8e, $status);
        }
        $_1833c1908972ebd0c77f861e80c2d9bf = $this->api->getProjectStatuses($project_id);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["statu" . "s"] => $this->FormatStatus($status), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["statuse" . "s"] => $this->FormatStatuses($_1833c1908972ebd0c77f861e80c2d9bf)], $_231341bedbbeea0ba9fa8da63ef63dc1 ? 201 : 200);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function Delete(int $project_id, TaskStatus $status, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $this->api->DeleteStatus($status);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["stat" . "us"] => $this->FormatStatus($status)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function DeleteV3(int $project_id, TaskStatus $status, PermissionsChecker $permissions_checker) : JsonPrettyResponse
    {
        $this->CheckProjectId($project_id, $status);
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $this->api->DeleteStatus($status);
        $_1833c1908972ebd0c77f861e80c2d9bf = $this->api->getProjectStatuses($project_id);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["stat" . "us"] => $this->FormatStatus($status), $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["stat" . "uses"] => $this->FormatStatuses($_1833c1908972ebd0c77f861e80c2d9bf)]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateTodo(PermissionsChecker $permissions_checker, int $project_id, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6) : JsonPrettyResponse
    {
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $project = $this->project_provider->GetProject($project_id);
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if (!$project) {
            throw new \RestExBadRequest(($this->lmsg)($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_f4afc0b7f4289969aa2dc510072873" . "1f"]));
        }
        if (!isset($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8dabb06efc95d" . "f4cff7c4afe918" . "57b53"]])) {
            throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8f4004bb39963606d04" . "2524cafb2c56e"]);
        }
        $project->SetProperty($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_5f4d1ad89c941500471a83" . "70398dad9e"], $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8dabb06efc95df4cff7c4afe91" . "857b53"]]);
        $this->project_provider->SaveProject($project);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["st" . "at" . "us"] => [$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_0ea4e32" . "b57963ac" . "0cb3057e" . "03e9aef6" . "4"] => Task::STATUS_TODO, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_8dabb06efc95df4cff7c4afe" . "91857b53"] => $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8dabb06efc95df4c" . "ff7c4afe91857b53"]], $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_4d23892ff91aa3195" . "a85bb548a7f4333"] => $this->lmsg->lmsg_str($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_8dabb06efc95df4cff7c4afe91857b" . "53"]])]]);
    }
    public function DeleteTodo()
    {
        throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_80f432640c97e2a" . "a412664c408f7222" . "1"]);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function UpdateCompleted(PermissionsChecker $permissions_checker, int $project_id, ServerRequestInterface $_b791059c94b285cdf1c90ca6f3a8f2a6) : JsonPrettyResponse
    {
        $this->CheckEditPermissions($project_id, $permissions_checker);
        $project = $this->project_provider->GetProject($project_id);
        $_ed5f03d686c37933b5943f295c6b4a43 = $this->formatter->GetJson($_b791059c94b285cdf1c90ca6f3a8f2a6);
        if (!$project) {
            throw new \RestExBadRequest(($this->lmsg)($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f4afc0b7f4289969aa2dc5100728" . "731f"]));
        }
        if (!isset($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_8dabb06efc95df4" . "cff7c4afe91857b5" . "3"]])) {
            throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8f4004bb39963606d0425" . "24cafb2c56e"]);
        }
        $project->SetProperty($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_9ed84d2923d81db75e6348d1b290c05" . "1"], $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_8dabb06efc95df4" . "cff7c4afe91857b5" . "3"]]);
        $this->project_provider->SaveProject($project);
        return new JsonPrettyResponse([$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["stat" . "us"] => [$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_0ea4e32b57" . "963ac0cb305" . "7e03e9aef64"] => Task::STATUS_COMPLETED, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8dabb06efc95df4c" . "ff7c4afe91857b53"] => $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8dabb06efc95df4cff7c4afe91857" . "b53"]], $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_4d23892ff91aa31" . "95a85bb548a7f433" . "3"] => $this->lmsg->lmsg_str($_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_8dabb06efc95df4" . "cff7c4afe91857b5" . "3"]])]]);
    }
    public function DeleteCompleted()
    {
        throw new \RestExBadRequest($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_7d5f0a31f61b7b734f21a9bf6acf" . "2502"]);
    }
    
    
    
    
    
    
    
    private function CheckEditPermissions(int $project_id, PermissionsChecker $permissions_checker)
    {
        if (!$permissions_checker->CanI($project_id, Permissions::EDIT_PROJECT_PROPERTIES)) {
            throw new \RestExForbidden($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_a29b27c98290e926d8b0" . "84b48c9ce369"]);
        }
    }
    
    
    
    
    
    
    
    private function CheckProjectId(int $project_id, TaskStatus $status)
    {
        if ($status->project_id && $project_id !== $status->project_id) {
            throw new \RestExNotFound($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_b94c0530a0fc194218" . "65e1efa5f6779f"] . $status->id . $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f805302e3f25df291a3dd8ea38" . "6da8a4"] . $project_id);
        }
    }
    private function FormatStatuses($statuses) : array
    {
        $_e8180e518b009dc0ea8c578fe193c4ae = [];
        
        
        foreach ($statuses as $status) {
            $_e8180e518b009dc0ea8c578fe193c4ae[] = $this->FormatStatus($status);
        }
        return $_e8180e518b009dc0ea8c578fe193c4ae;
    }
    
    
    
    
    
    
    private function FormatStatus(TaskStatus $status) : array
    {
        $status = $status->toArray();
        $status[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4d23892ff91" . "aa3195a85bb5" . "48a7f4333"]] = $this->lmsg->lmsg_str($status[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8dabb06efc95df4cff7c4afe91857b" . "53"]]);
        return $status;
    }
}