(function()
{
    var template = require('../../html/project/tasks_board_status_header.directive.html');
	var moduleName = 'claromentis.project';

	angular.module(moduleName)
        .directive('clangTasksBoardStatusHeader', tasksBoardStatusHeader);

    tasksBoardStatusHeader.$inject = ['$timeout', 'tasksService', 'confirmService'];
    function tasksBoardStatusHeader($timeout, service, confirmService) {
        return {
            restrict: 'E',
            templateUrl: template,
            scope: {
                status: '<',
                taskCount: '<',
                allowDrag: '<'
            },
            controllerAs: 'ctrl',
            bindToController: true,
            controller: controller
        };

        function controller()
        {
            var ctrl = this;

            ctrl.editName = '';
            ctrl.editMode = false;
            ctrl.hasEditPerms = service.canEditStatuses();

            ctrl.$onInit = function() {
                // For new statuses, jump straight to editing the name
                if (ctrl.status.isNew !== undefined && ctrl.status.isNew)
                    ctrl.startRename();
            };

            ctrl.isDraggable = function()
            {
                if (!ctrl.allowDrag)
                    return false;

                if (typeof ctrl.status.id !== 'number')
                    return false;

                if ((ctrl.status.id === -1) || (ctrl.status.id === -2))
                    return false;

                return true;
            };

            ctrl.startRename = function($event) {
                if ($event !== undefined)
                    $event.preventDefault();

                ctrl.editName = ctrl.status.localized_name;
                ctrl.editMode = true;

                $timeout(function() {
                    angular.element('#status_header_' + ctrl.status.id).focus();
                }, 0);
            };

            ctrl.cancelRename = function($event) {
                $event.preventDefault();

                ctrl.editMode = false;
                ctrl.status.isNew = false;
            };

            ctrl.rename = function($event) {
                if ($event !== undefined)
                    $event.preventDefault();

                service.renameStatus(ctrl.status.id, ctrl.editName);
                ctrl.editMode = false;
                ctrl.status.isNew = false;
            };

            ctrl.addStatusBefore = function($event)
            {
                $event.preventDefault();

                service.addStatusBefore(ctrl.status.sort_order);
            };

            ctrl.addStatusAfter = function($event)
            {
                $event.preventDefault();

                service.addStatusAfter(ctrl.status.sort_order);
            };

            ctrl.delete = function($event)
            {
                $event.preventDefault();

                if (ctrl.taskCount === 0)
                {
                    confirmService.show({
                        title: lmsg('projects.tasks.delete_status.title'),
                        message: lmsg('projects.tasks.delete_status.message', ctrl.status.localized_name)
                    }).then(function() {
                        service.deleteStatus(ctrl.status);
                    }, function() {});
                } else
                {
                    confirmService.show({
                        title: lmsg('projects.tasks.delete_status.title'),
                        message: lmsg('projects.tasks.delete_status.remove_tasks_message', ctrl.status.localized_name),
                        icon: 'list-alt',
                        mode: 'ok'
                    }).then(function() {}, function() {});
                }
            };
        }
    }
}());
