<?php
if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/**
 * @var $installer \Claromentis\Setup\SetupFacade
 */
$plugins = $installer->GetPluginsRepository();
$plugins->Add('quiz', 'Claromentis\Quiz\Plugin');

$panels = $installer->GetAdminPanelCreator();
$panels->Enable('quiz');
$panels->Enable('polls-surveys');

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('quiz', 'Quiz', '/quiz/'));
$menu->save(new MenuItemApplication('polls-surveys', 'Polls & Surveys', '/polls-surveys/'));
