// Karma configuration
// Generated on Tue Feb 14 2017 12:01:31 GMT+0000 (GMT)

module.exports = function(config) {
  config.set({

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: '',


    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine'],


    // list of files / patterns to load in the browser
    files: [
		'../../components/jquery/jquery.min.js',
	  	'../../components/cla_angular.js',
	  	'../../components/ng.cla.core.growl.js',
		'../../components/ng.cla.core.lmsg.js',
		'./node_modules/angular-mocks/angular-mocks.js',
		'../../components/datatable.js',
		'./js/src/ng/tests/bootstrap.js',
		'./js/src/ng/quiz.app.js',
		'./js/src/ng/quiz/actions.service.js',
		'./js/src/ng/quiz/interceptor.service.js',
      	'./js/src/ng/quiz/resources.service.js',
		'./js/src/ng/tests/quiz/resources.spec.js',
		'./js/src/ng/quiz/tracker.service.js',
		'./js/src/ng/tests/quiz/tracker.spec.js',
		'./js/src/ng/quiz/start.controller.js',
		'./js/src/ng/tests/quiz/start.controller.spec.js',
		'./js/src/ng/quiz/nav.directive.js',
		'./js/src/ng/tests/quiz/nav.directive.spec.js',
		'**/html/templates/**/*.html',
		'**/html/modals/**/*.html'
    ],


    // list of files to exclude
    exclude: [
    ],


    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
		"**/html/templates/**/*.html": ['ng-html2js'],
		"**/html/modals/**/*.html": ['ng-html2js']
    },

	// html 2 js preprocessor to handle directive templates in unit tests
	ngHtml2JsPreprocessor: {
		prependPrefix: '/intranet/quiz/',
		moduleName: 'quiz.templates'
	},

    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['spec'],


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['Chrome'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity
  })
}
