/**
 * Application initialization
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
define([
    'cla_angular',
    'ng.cla.core.growl',
    'ng.cla.core.lmsg',
    'datatable',
    'ng.cla.core.share'
], function (angular) {

    // angular defined by imports-loader
    angular.module('cla.poll', ['cla.core.growl', 'cla.core.lmsg', 'cla.core.datatable', 'cla.core.share', 'ngResource', 'ngRoute', 'ngSanitize'])
        .config(['$routeProvider', '$locationProvider', function ($routeProvider, $locationProvider) {
            $locationProvider.hashPrefix('');

            $routeProvider.when('/', {
                    controller: 'introController',
                    templateUrl: '/intranet/quiz/html/templates/poll/intro.html'
                })

                .when('/start|/continue', {
                    controller: 'startController',
                    templateUrl: '/intranet/quiz/html/templates/poll/question.html?v=1.4.0'
                })

                .when('/finish/:attempt|/finish', {
                    controller: 'finishController',
                    templateUrl: '/intranet/quiz/html/templates/poll/finish.html'
                })

                .when('/review', {
                    controller: 'reviewController',
                    templateUrl: '/intranet/quiz/html/templates/poll/review.html'
                })

                .otherwise({
                    redirectTo: function () {
                        window.location.href = '/quiz?message=quiz does not exist&is_error_message=1';
                    }
                })
        }]);
});
