/**
 * Navigation bar within a quiz
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
    'use strict';

    angular.module('cla.quiz')
        .directive('claQuizNavBar', navBar);

    navBar.$inject = ['quizTracker', 'quizActions'];

    /**
     *
     * @param quizTracker
     * @param quizActions
     * @constructor
     */
    function navBar(quizTracker, quizActions) {
        return {
            bindToController: true,
            controller: controller,
            controllerAs: 'navbar',
            link: link,
            replace: true,
            restrict: 'E',
            scope: {
                quizId: '@'
            },
            templateUrl: '/intranet/quiz/html/templates/quiz/navbar.html'
        };

        function controller() {

            var $ctrl = this;

            this.questions = [];
            this.instantFeedback = false;

            this.navigate = navigate;
            this.isActive = isActive;
            this.getNavClass = getNavClass;
            this.isDisabled = isDisabled;

            init();

            function init() {
                $ctrl.questions = quizTracker.questions;
            }

            /**
             * go to a given question
             * @param $index
             */
            function navigate($index) {
                quizActions.next($ctrl.quizId);

                // todo: simpler?
                //quizTracker.goto(quizTracker.tracker[$index]);

                for (var i = 0; i < quizTracker.tracker.length; i++) {
                    if (quizTracker.tracker[i] == $index) {
                        quizTracker.goto(i);
                        break;
                    }
                }
            }

            /**
             * is the currently selected question active?
             * @param $index
             * @returns {boolean}
             */
            function isActive($index) {
                return quizTracker.question == $index;
            }

            /**
             * determines if a question is disabled (not in the tracker list)
             * @param $index
             * @returns {boolean}
             */
            function isDisabled($index) {
                for (var i = 0; i < quizTracker.tracker.length; i++) {
                    if (quizTracker.tracker[i] == $index)
                        return false;
                }
                ;
                return true;
            }

            /**
             * Get the nav card class
             * @param $index
             */
            function getNavClass($index) {
                // instant feedback turned on?
                if ($ctrl.instantFeedback) {
                    // did the user get the question right or wrong?
                    return 'glyphicons-ok-circle'; // : 'glyphicons-remove-circle'
                }

                // no instant feedback, question mark if answered, circle if unanswered.
                return !!quizTracker.chosen[$index] ? 'quiz-questions-nav__question--state complete primary_bg_color' : 'quiz-questions-nav__question--state';
            }
        }


        function link(scope) {

            var width, border, li, offset;

            // watch the track position changing so we know to update the navbar offset
            scope.$watch(function () {
                return quizTracker.trackpos;
            }, function (value) {
                if (!width) {
                    // only calculate this once when first watch loads
                    li = $('.quiz-nav .slide-nav__question--active');
                    width = li.children('button').outerWidth();
                    offset = width;
                }

                var pos = (offset * value) + offset; // add offset each time to account for "intro" button
                $('.slider-quiz-nav').animate({scrollLeft: pos}, 500);
            });


            $(window).on("resize", function () {
                var win = $(this); //this = window
                if (win.width() >= 980) {
                    $('.slider-quiz-nav').kinetic('attach');
                } else {
                    $('.slider-quiz-nav').kinetic('detach');
                }
            }).resize();


            // on scroll, check position and add or remove the necessary "end" class
            $('.slider-quiz-nav').on('scroll', function () {
                if ($(this).scrollLeft() + $(this).innerWidth() >= $(this)[0].scrollWidth - 50) {
                    $(".slider-nav-wrap").addClass("end");
                } else {
                    $(".slider-nav-wrap").removeClass("end");
                }
            });
        }
    }
}());
