/**
 * Handles redirection to various Quiz pages.
 *
 * @author Chris Andrew <chris.andrew@claromentis.com>
 */
(function () {
    'use strict';

    angular.module('cla.quiz')
        .service('quizRedirect', quizRedirect);

    quizRedirect.$inject = ['growl.service', '$window'];

    function quizRedirect(growlService, $window) {
        var service = {
            quizUrl: quizUrl,
            redirect: redirect,
            toQuiz: toQuiz,
            toQuizList: toQuizList
        };

        return service;

        /**
         * Get the path for a quiz.
         *
         * @param {int} quiz_id
         * @returns {string}
         */
        function quizUrl(quiz_id) {
            return '/quiz/' + quiz_id;
        }

        /**
         * Redirect to the given path, optionally with a message and error flag.
         *
         * @param {string} pathname
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function redirect(pathname, message, is_error) {
            if (!message) {
                $window.location.pathname = pathname;

                return;
            }

            growlService.flash(message, null, is_error, pathname);
        }

        /**
         * Redirect to a quiz's intro page.
         *
         * @param {int} quiz_id
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toQuiz(quiz_id, message, is_error) {
            service.redirect(quizUrl(quiz_id), message, is_error);
        }

        /**
         * Redirect to the quiz list page.
         *
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toQuizList(message, is_error) {
            service.redirect('/quiz', message, is_error);
        }
    }
}());
