<?php
namespace Claromentis\Quiz\Facade;

$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] ?: array()) + array("_8bafa036940b9541eaa68bf" . "ae2d457ab" => base64_decode("dGltZV90Y" . "Wtlbg=="), "_9624bbc4" . "54278afb5" . "470b43ba4" . "e309aa" => base64_decode("cXVpel9wZXJjZ" . "W50"), "_2efbc177e1ad89b385c991" . "e1a24c3d4d" => base64_decode("cXVpei5lcnJvci5ub19xdWVzdGlvbn" . "M="), "_670ae7cfad454a5d2068a" . "664fe492b8b" => base64_decode("cGFzc2" . "Vk"), "_b4af1f7aa1ccde1a449e9" . "d8afe15b753" => base64_decode("cmVzd" . "Wx0cw" . "=="), "_bc29a32ad8f2fef03c86624cd1f971" . "74" => base64_decode("cXVpei5lcnJ" . "vci5hdHRlbX" . "B0X2NhbmNlb" . "GxlZA=="), "_824bf7ef94e1d4ffd60" . "109eae15a03de" => base64_decode("c2hvd19yZXN1b" . "HRz"), "_48b11ff6a9c9a96" . "2ed664af78198907" . "6" => base64_decode("ZGF0ZV9j" . "b21wbGV0" . "ZWQ="), "_7864d2966f47ed1bdb40457d0c0f" . "c6cd" => base64_decode("Z21" . "kYX" . "Rl"), "_0c5123aa744f69bbc0e8b3ea2" . "f6e847d" => base64_decode("bG1z" . "Zw=="), "_5413cd74" . "395149d2e" . "b1ed57dca" . "5f7f6d" => base64_decode("dXNlcl9wb2ludHM" . "="), "_b9c4587b9af707e3b9b62f38b" . "8bd07d0" => base64_decode("SD" . "pp" . "On" . "M="), "_2424e587f1d2260ed1" . "140b0c3a04957c" => base64_decode("cXVpei5lcnJvci5ub1" . "9hdHRlbXB0X3Blcm1z"), "_4a397d01c1669f4fc3143b" . "3ede57982a" => base64_decode("bWF4X3BvaW" . "50cw=="), "_5846ddea7ff6d30bd0e7b4" . "a81710776e" => base64_decode("YXJyYXlf" . "c2hpZnQ="), "_69be62fd7fe" . "74eeb696430b" . "ef3e07069" => base64_decode("c2hvd19oZ" . "WxwX3RleH" . "Q="), "_62d701c3c53404f06345" . "eb35720a47b4" => base64_decode("aXNfbnVtZXJ" . "pYw=="), "atte" . "mpt_" . "id" => base64_decode("YXR0ZW1wdF9" . "pZA=="), "_b1d9743b68fd8" . "1cc4d60987cbf4" . "b4f57" => base64_decode("YW5" . "zd2" . "Vyc" . "w=="), "_0c7db5a15ed94" . "cc1be4b039915f" . "b0814" => base64_decode("Y2FuX3JldGFrZ" . "Q=="), "_381f559a7" . "2e38d18269" . "6693daaec5" . "aaf" => base64_decode("YXJyY" . "Xlfcm" . "VkdWN" . "l"), "_1f61c253d44e3b7dfa35ebe010c" . "3f61d" => base64_decode("cXVp" . "el9w" . "b2lu" . "dHM="));
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\People\Exception\PermissionException;
use Claromentis\Quiz\Model;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository;
use Exception;
use RestExForbidden;
use RestExNotFound;





class QuizFacade
{
    
    
    
    
    protected $attempt_repo;
    
    
    
    
    private $quiz_repo;
    
    
    
    
    private $question_repo;
    
    
    
    
    private $junction_repo;
    
    
    
    
    private $option_repo;
    
    
    
    
    
    
    
    
    
    
    public function __construct(Repository\QuizRepository $quiz_repo, Repository\QuestionRepository $question_repo, Repository\QuizQuestionRepository $junction_repo, Repository\OptionRepository $option_repo, Repository\AttemptRepository $attempt_repo)
    {
        $this->quiz_repo = $quiz_repo;
        $this->question_repo = $question_repo;
        $this->junction_repo = $junction_repo;
        $this->option_repo = $option_repo;
        $this->attempt_repo = $attempt_repo;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetQuestionsForQuiz($quiz, $question_id = 0, $_a533ab42257ef7a3ab56ae81095ba76a = false, $_f11369824f533e8206f9ccc0c9aab3a0 = 0, $_1f50e30be8c2fefa6881834e71d504a2 = 0)
    {
        $quiz_id = $quiz;
        
        
        if ($quiz instanceof Model\Quiz) {
            $quiz_id = $quiz->id;
        }
        
        
        $_c3260c2f0284e4cb0a840360d54cfc77 = $this->junction_repo->ListJunctions($quiz_id, $question_id);
        
        
        $_ccac80360ec3a22ae939584a5b406d92 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_381f559a72e38d1" . "82696693daaec5aa" . "f"]($_c3260c2f0284e4cb0a840360d54cfc77, function ($_ea3aa8b636de2853263bc04cc6356846, $_59cdb5ce92fcf760d09d3c6ed5b03aaa) {
            $_ea3aa8b636de2853263bc04cc6356846[] = (int) $_59cdb5ce92fcf760d09d3c6ed5b03aaa->question_id;
            return $_ea3aa8b636de2853263bc04cc6356846;
        }, []);
        
        
        $questions = array();
        if ($_ccac80360ec3a22ae939584a5b406d92) {
            $questions = $this->question_repo->GetQuizQuestions($quiz_id, $_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2);
        }
        
        
        if (!$_a533ab42257ef7a3ab56ae81095ba76a) {
            return $questions;
        }
        
        
        $this->option_repo->LoadQuestionOptions($questions);
        return $questions;
    }
    
    
    
    
    
    
    
    
    public function GetOptionsForQuestion($question, $option_id = 0)
    {
        return $this->option_repo->GetOptionsForQuestion($question, $option_id);
    }
    
    
    
    
    
    
    
    public function GetEntireQuiz($quiz_id)
    {
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_62d701c3c53404f06345eb35720" . "a47b4"]($quiz_id)) {
            return null;
        }
        
        
        $quiz = $this->quiz_repo->Get($quiz_id);
        
        
        $questions = $this->GetQuestionsForQuiz($quiz->id);
        
        
        $this->option_repo->LoadQuestionOptions($questions);
        
        
        $quiz->SetQuestions($questions);
        return $quiz;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function GetQuizWithQuestion($quiz_id, $question_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        $question = $this->question_repo->Get($question_id);
        $question->SetOptions($this->option_repo->GetOptionsForQuestion($question_id));
        return array($quiz, $question);
    }
    
    
    
    
    
    
    
    public function GetQuizWithQuestionsCount($quiz_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        $quiz->SetQuestionsCount($this->GetQuestionsCount($quiz));
        return $quiz;
    }
    
    
    
    
    
    
    
    public function GetQuestionsCount($quiz)
    {
        return $this->question_repo->GetQuizQuestionsCount($quiz);
    }
    
    
    
    
    
    
    
    public function GetQuizPassMark($quiz_id)
    {
        $quiz = $this->GetEntireQuiz($quiz_id);
        return $quiz->GetPassPoints();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function DeleteQuiz($quiz_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        
        
        
        $_c3260c2f0284e4cb0a840360d54cfc77 = $this->junction_repo->ListJunctions($quiz->id);
        
        
        $this->quiz_repo->Delete($quiz);
        
        
        foreach ($_c3260c2f0284e4cb0a840360d54cfc77 as $_c802a23eaf40ed8ad9096c3f27fe3200) {
            $this->junction_repo->Delete($_c802a23eaf40ed8ad9096c3f27fe3200);
        }
    }
    
    
    
    
    
    
    
    
    public function DeleteQuestion($quiz_id, $question_id)
    {
        
        
        $_c802a23eaf40ed8ad9096c3f27fe3200 = $this->junction_repo->ListJunctions($quiz_id, $question_id);
        if ($_c802a23eaf40ed8ad9096c3f27fe3200) {
            $_c802a23eaf40ed8ad9096c3f27fe3200 = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_5846ddea7ff6d30bd0e7b4a817107" . "76e"]($_c802a23eaf40ed8ad9096c3f27fe3200);
            
            
            $this->junction_repo->Delete($_c802a23eaf40ed8ad9096c3f27fe3200);
        }
    }
    
    
    
    
    
    
    
    
    public function VerifyAttempt($acl, $context, $quiz_id)
    {
        $quiz = $this->GetEntireQuiz($quiz_id);
        
        
        
        if (!$quiz->HasQuestionsCount()) {
            throw new PermissionException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_0c5123a" . "a744f69b" . "bc0e8b3e" . "a2f6e847" . "d"]($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_2efbc177e1ad89b385c" . "991e1a24c3d4d"]));
        }
        
        
        
        
        if ($quiz->IsDraft()) {
            throw new PermissionException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_0c5123aa744f69bbc0" . "e8b3ea2f6e847d"]($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_bc29a32ad8f2fef0" . "3c86624cd1f97174"]));
        }
        
        
        if (!QuizPermissions::CanAttempt($acl, $context, $quiz, $this->attempt_repo)) {
            throw new PermissionException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_0c5123aa744f" . "69bbc0e8b3ea2" . "f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_2424e587f1d2" . "260ed1140b0c3" . "a04957c"]));
        }
        
        
        return $quiz;
    }
    
    
    
    
    
    
    
    
    public function GetResults(Model\Attempt $_7adc269a13af5c45b5a1caf4ec75a795, $_b1d9743b68fd81cc4d60987cbf4b4f57, $context)
    {
        $object_id = $_7adc269a13af5c45b5a1caf4ec75a795->GetObjectId();
        $quiz = $this->GetEntireQuiz($object_id);
        $_0334d5cb3805f030a3472f168811ab71 = 0;
        $_ebcdbaf89b6fd6aaf65fb108576f9cbc = false;
        if ($_7adc269a13af5c45b5a1caf4ec75a795) {
            $_ebcdbaf89b6fd6aaf65fb108576f9cbc = (bool) $_7adc269a13af5c45b5a1caf4ec75a795->has_passed;
            $_0334d5cb3805f030a3472f168811ab71 = $_7adc269a13af5c45b5a1caf4ec75a795->GetScore();
        }
        $_2d06e7ff8ab3c552256f153de1fdedd2 = new \Date($_7adc269a13af5c45b5a1caf4ec75a795->completed_date);
        $_8bafa036940b9541eaa68bfae2d457ab = $_7adc269a13af5c45b5a1caf4ec75a795->GetPropertyCollection()->GetValue($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_8bafa036940b9541e" . "aa68bfae2d457ab"]);
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_b4af1f7aa1ccde1" . "a449e9d8afe15b75" . "3"]] = array($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_670ae7cfad454a5d2" . "068a664fe492b8b"] => $_ebcdbaf89b6fd6aaf65fb108576f9cbc, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_5413cd74395149d2eb1ed57dca5" . "f7f6d"] => $_0334d5cb3805f030a3472f168811ab71, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_1f61c253d44e3b7dfa" . "35ebe010c3f61d"] => $quiz->GetPassPoints(), $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4a397d01c166" . "9f4fc3143b3ed" . "e57982a"] => $quiz->GetTotalPoints(), $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_9624bbc45427" . "8afb5470b43ba" . "4e309aa"] => $quiz->pass_percent, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_8bafa036940b9541" . "eaa68bfae2d457ab"] => $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_7864d2966f47ed1bdb40457d0c" . "0fc6cd"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_b9c4587b9af707e3b9b" . "62f38b8bd07d0"], $_8bafa036940b9541eaa68bfae2d457ab / 1000), $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_48b11ff6a9c" . "9a962ed664af" . "781989076"] => $_2d06e7ff8ab3c552256f153de1fdedd2->getDate(DATE_FORMAT_CLA_LONG_DATE), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_69be62fd7fe74eeb696430b" . "ef3e07069"] => (int) $quiz->show_help_text, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_824bf7ef94" . "e1d4ffd6010" . "9eae15a03de"] => (int) $quiz->show_results);
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["attempt_" . "id"]] = (int) $_7adc269a13af5c45b5a1caf4ec75a795->id;
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_b1d9743b68fd81cc4" . "d60987cbf4b4f57"]] = $_b1d9743b68fd81cc4d60987cbf4b4f57;
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_0c7db5a15ed9" . "4cc1be4b03991" . "5fb0814"]] = QuizPermissions::CanReattempt($this->attempt_repo, $context, $quiz);
        return $_ed5f03d686c37933b5943f295c6b4a43;
    }
}