<?php
namespace Claromentis\Quiz\Search\Indexing;

$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] = (@$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"] ?: array()) + array("_99cee2d2272a8550f4b21e" . "3cb57fff7d" => base64_decode("ZW5hYmxlZA=" . "="), "_5296e137570b02bad" . "64c772bd9d734de" => base64_decode("VW5rbm93biBzcGVjaWFsIGFjdGlvbiBmb3IgUXVpe" . "iBpbmRleGluZzog"), "_4d707fab93bebb00bbe69e8159697c" . "90" => base64_decode(""), "_f73dab6066" . "30b388645c4" . "f7d3fbb13bb" => base64_decode("YXJyYXlfbW" . "VyZ2U="), "_646df530340668323d9a8e6c9204" . "fe75" => base64_decode("aW1hZ" . "2Vfc3" . "Jj"), "_33de78378f32407b852c241ec" . "52f9a35" => base64_decode("aHJlZg=" . "="), "_b0eaaa9541f479b4891f616111" . "7437b9" => base64_decode("cXVldWVfZnVsbF9yZ" . "WluZGV4"), "_aa7e860da1" . "acd4e767e0d" . "f9d7d407380" => base64_decode("ZGF0ZV9" . "jcmVhdG" . "Vk"), "_d0acf63c20abded6f7458ea8e7009e" . "96" => base64_decode("SW5zdHJ1Y3Rpb24gb2JqZWN0IElEI" . "G5vdCBmb3VuZCBmb3IgUXVpeg=="), "_66824e0309bb76c78bd2bb" . "d5fda8d3d8" => base64_decode("c3RyaW5" . "n"), "_d7bc4f883b1e96e6f534" . "b781dedddd6b" => base64_decode("Z2x5cGhpY29ucyBnbHlwaGljb25z" . "LXF1ZXN0aW9uLXNpZ24="), "permis" . "sions" => base64_decode("cGVybWlzc2lvbn" . "M="), "_e03f42611" . "10db60749f" . "3b7cd2c237" . "77f" => base64_decode("UXVpeiA" . "="), "_8e7f4b5c8440c0a24fb1b632eee2853" . "8" => base64_decode("YW" . "N0" . "aW" . "9u"), "_b15aac3" . "aa29c10e" . "a6d1228f" . "58cb9a7e" . "8" => base64_decode("b2J" . "qZW" . "N0"), "_feb9037589181b" . "c30fa0f1cf78b9f" . "056" => base64_decode("dG" . "l0" . "bG" . "U="), "_31767d7ad58e706dbf47b7a5" . "1a0fe6c4" => base64_decode("Y2" . "91" . "bn" . "Q="), "_fa96cdf58bff3b0695fb2bc080" . "3d7b12" => base64_decode("IGRvZXMgbm90IGV" . "4aXN0"), "_df49a98e6130f798876ec" . "bf6bddc70d9" => base64_decode("UXVpeiB3aXRoI" . "ElEIA=="), "_d34599daeb8cca374d3adb" . "38b245839c" => base64_decode("Y29" . "udG" . "Vud" . "HM="), "_809a58dc73011173c031a53c0b40ef" . "0e" => base64_decode("cHJvc" . "GVydG" . "llcw=" . "="), "_2b2fdacf7b152c" . "ff4f3819c30fd58" . "b1a" => base64_decode("L3F1aXo" . "v"), "_dadf790baf241afa" . "c942824c1e6e37c4" => base64_decode("dHlw" . "ZQ=="), "_8e7b0b07b8da9" . "d5cbd9a41129b6" . "29400" => base64_decode("ZGF0ZV9kZXR" . "lY3Rpb24="), "_07954ed0fb98865511b46872442755" . "02" => base64_decode("cXVpei" . "9jb3Zl" . "cnM="), "_d43b1a885195a4b6ccc7d38ba3fcb1" . "f9" => base64_decode("Z2x5cGhp" . "Y29u"), "_7aefd48" . "2de7885f" . "4293c292" . "6df28c23" . "5" => base64_decode("anNvbl9lbmNvZ" . "GU="), "_6ebc0afe64bb119c" . "e3df66d2745d8c38" => base64_decode("IGlzIG5vdCBMaXZlLCBzbyBpdCB3aWxsIG" . "5vdCBiZSBpbmRleGVk"), "_8ac93b484d7470c59e327620" . "646e2d1e" => base64_decode("X3NvdX" . "JjZQ=="));
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\CDN\CDNInterface;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Quiz\Model\Quiz;
use Claromentis\Quiz\Permissions\QuizAdminPermissions;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository\QuizRepository;
use Claromentis\Search\FieldType\TypeContents;
use Claromentis\Search\FieldType\TypeDate;
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Exception\IndexingException;
use Claromentis\Search\Indexing\Exception\NothingToIndexException;
use Claromentis\Search\Indexing\Exception\ObjectNotFoundException;
use Claromentis\Search\Indexing\Exception\UnsupportedOperationException;
use Claromentis\Search\Indexing\IndexingInstruction;
use Claromentis\Search\Indexing\IndexingItemInterface;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\Permissions as SearchPermissions;
use ClaText;
use Permissions;




class QuizIndexing implements IndexingItemInterface
{
    const TYPE_NAME = 'quiz';
    
    
    protected $cdn;
    
    
    protected $cla_text;
    
    
    protected $quiz_repo;
    
    
    protected $acl_repo;
    public function __construct(CDNInterface $cdn, \Claromentis\Core\TextUtil\ClaText $cla_text, QuizRepository $quiz_repo, AclRepository $_3436ad73cf80729d5a2e43d861c31e8b)
    {
        $this->cdn = $cdn;
        $this->cla_text = $cla_text;
        $this->quiz_repo = $quiz_repo;
        $this->acl_repo = $_3436ad73cf80729d5a2e43d861c31e8b;
    }
    
    
    
    
    
    
    public function InitMapping(ClientInterface $_87419315d6aaaec7dd2250b14245566e)
    {
        $_87419315d6aaaec7dd2250b14245566e->AddMapping(self::TYPE_NAME, [$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_8ac93b484d7470c" . "59e327620646e2d1" . "e"] => [$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_99cee2d2272" . "a8550f4b21e3" . "cb57fff7d"] => true], $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_8e7b0b07b8da9d5cbd9a41129b62" . "9400"] => true, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_809a58dc73011173c031a" . "53c0b40ef0e"] => [$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_feb903758" . "9181bc30fa" . "0f1cf78b9f" . "056"] => [$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_dadf790baf241afac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_66824e0309bb76" . "c78bd2bbd5fda8d" . "3d8"]], $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_33de78378f32407b852c241ec52f" . "9a35"] => [$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dadf790baf241afac942824c1e6" . "e37c4"] => $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_66824e0309b" . "b76c78bd2bbd" . "5fda8d3d8"], $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_99cee2d2272a855" . "0f4b21e3cb57fff7" . "d"] => false], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_646df530340668323d9a8e6c" . "9204fe75"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_dadf790baf241afac942824c1e6e37c" . "4"] => $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_66824e0309bb" . "76c78bd2bbd5f" . "da8d3d8"], $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_99cee2d2" . "272a8550f" . "4b21e3cb5" . "7fff7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_d43b1a885195a4b6ccc7d38" . "ba3fcb1f9"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_dadf790baf241afac942824c1e6e" . "37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_66824e0309bb" . "76c78bd2bbd5f" . "da8d3d8"], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_99cee2d2272a8550f4b21e3cb57f" . "ff7d"] => false], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_d34599daeb8cca374d3adb38b245" . "839c"] => TypeContents::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_aa7e860da1" . "acd4e767e0d" . "f9d7d407380"] => TypeDate::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["permissio" . "ns"] => array($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dadf790baf" . "241afac9428" . "24c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_b15aac3aa29c10ea6d1228" . "f58cb9a7e8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_809a58dc73011173c" . "031a53c0b40ef0e"] => SearchPermissions::GetPropertiesMapping())]]);
    }
    
    
    
    
    
    
    
    public function Index(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_d0acf63c20ab" . "ded6f7458ea8e" . "7009e96"]);
        }
        
        
        
        
        $_8652ba33e6ffeba02459fa9cbb320851 = $this->quiz_repo;
        try {
            
            
            
            
            $quiz = $_8652ba33e6ffeba02459fa9cbb320851->Get($_8c5f17e2e918145535955f8a633b6c7b->object_id);
        } catch (NotFoundException $_c35473364fa7a050299058f332ec29c1) {
            throw new ObjectNotFoundException($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_df49a98e6" . "130f798876" . "ecbf6bddc7" . "0d9"] . $_8c5f17e2e918145535955f8a633b6c7b->object_id . $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_fa96cdf58bff3b0695f" . "b2bc0803d7b12"]);
        }
        
        
        if (!$quiz->IsLive()) {
            throw new NothingToIndexException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_e03f4261110db6" . "0749f3b7cd2c237" . "77f"] . $quiz->id . $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_6ebc0afe64bb119ce3df66d2745d8c3" . "8"]);
        }
        
        
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = $this->GetIndexData($quiz);
        $_87419315d6aaaec7dd2250b14245566e->Index(self::TYPE_NAME, $quiz->id, $_a6fb9cc38e2b15d5b2d8171e60aa3cbe);
    }
    
    
    
    
    
    
    protected function GetIndexData(Quiz $quiz)
    {
        $_6137f6b1054c046b6733dcd025f03c02 = $quiz->GetImage($this->cdn, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_07954ed0fb98865511b4687244275" . "502"]);
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = [$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_feb9037589181bc30fa0f1cf78b9f" . "056"] => $quiz->title, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_33de78378f32407b852c" . "241ec52f9a35"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_2b2fdacf7b152cff4f3" . "819c30fd58b1a"] . $quiz->id, $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_646df53034066" . "8323d9a8e6c920" . "4fe75"] => $_6137f6b1054c046b6733dcd025f03c02, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_d34599daeb8cca374" . "d3adb38b245839c"] => $this->cla_text->BBCode2Plain((string) $quiz->description), $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_aa7e860da1acd4e767e0df9d7d4073" . "80"] => TypeDate::Format($quiz->created_date), $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["permissi" . "ons"] => $this->GetPermissionsIndexData($quiz)];
        if ($_6137f6b1054c046b6733dcd025f03c02 === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_4d707fab" . "93bebb00b" . "be69e8159" . "697c90"]) {
            $_a6fb9cc38e2b15d5b2d8171e60aa3cbe[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_d43b1a885195a4b6ccc7d38ba" . "3fcb1f9"]] = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d7bc4f883b1e96e6" . "f534b781dedddd6b"];
        }
        return $_a6fb9cc38e2b15d5b2d8171e60aa3cbe;
    }
    
    
    
    
    
    
    
    protected function GetPermissionsIndexData(Quiz $quiz)
    {
        
        
        $permissions = new Permissions(QuizPermissions::CLASS_QUIZ, $quiz->id);
        $permissions->Load();
        $_665240f1a489ba897ccc8ace510a47cb = new Permissions(QuizAdminPermissions::CLASS_QUIZ_ADMIN, 1);
        $_665240f1a489ba897ccc8ace510a47cb->Load();
        
        
        $_c9dab5b1c7628cf9721eea495ec5d40b = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_f73dab6066" . "30b388645c4" . "f7d3fbb13bb"]($_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_MANAGE_ALL), $_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_VIEW_ALL_STATISTICS));
        
        
        foreach ($_c9dab5b1c7628cf9721eea495ec5d40b as $_c4d674abe9291be143b224c411958fcf) {
            list($_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d) = $_c4d674abe9291be143b224c411958fcf;
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, $_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d);
        }
        
        
        $_f053e79538903e098fb90b42736274df = QuizAdminPermissions::CanManageOwn($this->acl_repo, SecurityContext::CreateForUser($quiz->created_by));
        if ($_f053e79538903e098fb90b42736274df) {
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, PermOClass::INDIVIDUAL, $quiz->created_by);
        }
        
        
        $_5572df110aae46854e281078ba4712b2 = new SearchPermissions();
        return $_5572df110aae46854e281078ba4712b2->GetIndexDataSimple($permissions);
    }
    
    
    
    
    
    
    public function Delete(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        
        
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            return;
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Delete(self::TYPE_NAME, $_8c5f17e2e918145535955f8a633b6c7b->object_id);
    }
    
    
    
    
    
    
    protected function GetAllQuizIds()
    {
        return $this->quiz_repo->ListQuizIds(false);
    }
    
    
    
    
    
    
    public function QueueFullIndex()
    {
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Index(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_31767d7ad58e706dbf47b7a5" . "1a0fe6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    public function QueueFullReindex($_4433a5922f5df0ebd8436fbb431e146c)
    {
        if (!$_4433a5922f5df0ebd8436fbb431e146c) {
            return $this->QueueFullIndex();
        }
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Reindex(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_31767d7ad58e706" . "dbf47b7a51a0fe6c" . "4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    
    public function Special(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        $_8e7f4b5c8440c0a24fb1b632eee28538 = $_8c5f17e2e918145535955f8a633b6c7b->extra[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8e7f4b5c8440c0a24fb1b632" . "eee28538"]];
        if ($_8e7f4b5c8440c0a24fb1b632eee28538 !== $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_b0eaaa95" . "41f479b48" . "91f616111" . "7437b9"]) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_5296e137570b02b" . "ad64c772bd9d734d" . "e"] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_7aefd482de78" . "85f4293c2926d" . "f28c235"]($_8c5f17e2e918145535955f8a633b6c7b->extra));
        }
        $this->QueueFullReindex(true);
    }
}