define(['jquery'], function ($) {
    // Keep track of variables needed for "show more" and filtering
    var options = {
        offset: 0,
        limit: 12,
        keywords: ''
    };

    function applyCards(body) {
        if (body.trim() === '')
        {
            $('.js-cards').hide();
            $('.js-no-results').show();
        } else
        {
            // Use the quiz cards HTML as the list
            $('.js-no-results').hide();
            $('.js-cards').show();
        }

        $('.js-cards').html(body);
    }

    // Set up initial view
    applyCards($('.js-cards').html() || '');

    return function (paginationLimit) {
        if (paginationLimit !== undefined)
            options.limit = paginationLimit;

        // Compile the underscore template that lists current user attempts
        var template = _.template($('.js-edit-modal-attempts-template').html());

        // Listen for click events on quiz edit links
        $('.js-cards').on('click', '.js-quiz-link-edit', function (event) {
            var card = $(event.target).parents('.js-quiz-link-edit');
            var data = card.data();

            // We don't need to show this modal for non-live quizzes, or live
            // quizzes that haven't been attempted
            if (!data.statusLive || !data.attempts) {
                return;
            }

            // Reset the incomplete attempts blocks
            $('.js-edit-modal-attempt-count').html(lmsg('quiz.admin.edit_live_quiz_attempts_none'));
            $('.js-edit-modal-attempts').html(null);

            // Load the incomplete attempts
            $.get('/api/quiz/' + data.quizId + '/current_attempts', function (data) {
                // Only list attempts if we have at least one
                if (data.total > 0) {
                    // Update the count of current attempts
                    $('.js-edit-modal-attempt-count').html(lmsg('quiz.admin.edit_live_quiz_attempts_count', data.total));

                    // Use the underscore template to print the list of attempts
                    $('.js-edit-modal-attempts').html(template(data));
                }
            }).fail(function (xhr) {
                cla.showMessage(lmsg('quiz.error.load_current_attempts'), null, true);
            });

            // Show the modal
            $('#edit-modal').modal({
                show: true
            });

            // Update the modal submit link to the quiz ID of the chosen card
            $('.js-edit-anyway').attr('href', '/quiz/' + data.quizId + '/review');

            event.preventDefault();
        });

        // Listen for click events on the show more button
        $('.js-show-more').on('click', function (event) {
            var button = $(event.target);

            options.offset = button.data('offset');

            // Disable the button until loading is complete
            button.attr('disabled', true);

            $.get('/quiz/list', options, function (data) {
                // Append the quiz cards HTML to the list
                $('.js-cards').append(data.html);

                // Update the offset for the next load
                button.data('offset', data.nextOffset);

                // Re-enable the button
                button.removeAttr('disabled');

                if (!data.nextOffset)
                    button.hide();
                else
                    button.show();
            }).fail(function () {
                cla.showMessage(lmsg('quiz.error.show_more'), null, true);
            });
        });

        $('#keywordFilter').on('keyup', _.debounce(function() {
            var button = $('.js-show-more');

            options.keywords = $(this).val();

            // Reset to first page
            options.offset = 0;

            // Disable the "Show more" button until loading is complete
            button.attr('disabled', true);

            $.get('/quiz/list', options, function (data) {
                applyCards(data.html);

                // Update the offset for the next load
                button.data('offset', data.nextOffset);

                // Re-enable the button
                button.removeAttr('disabled');

                if (!data.nextOffset)
                    button.hide();
                else
                    button.show();
            }).fail(function () {
                cla.showMessage(lmsg('quiz.error.show_more'), null, true);
            });
        }, 300));
    };
});
