(function () {
    'use strict';

    angular.module('cla.poll')
        .service('pollInterceptor', pollInterceptor);

    pollInterceptor.$inject = ['$resource', '$q'];

    /**
     *
     * @param $resource
     * @param $q
     * @constructor
     */
    function pollInterceptor($resource, $q) {
        var service = {
            start: start,
            submit: submit,
            finish: finish,
            quiz: quiz
        };

        return service;

        /**
         * call a different endpoint when starting with interceptor. just retrieve the list of questions
         * @param defaults
         * @param options
         * @returns {*}
         */
        function start(defaults, options) {
            return $resource('/api/quiz/v2/polls/:id/question', {}, {questions: {}})
                .questions(defaults, options);
        }

        /**
         * create a fake promise and resolve with an empty object
         * @returns {{$promise: *}}
         */
        function submit() {
            var defer = $q.defer();
            defer.resolve({});
            return {$promise: defer.promise};
        }

        /**
         * create a fake promise and resolve with an object with status of 0
         * @returns {{$promise: *}}
         */
        function finish() {
            var defer = $q.defer();
            defer.resolve({status: 0});
            return {$promise: defer.promise};
        }

        /**
         * call the quiz endpoint just as in resource. We don't need to skip this one
         * @param defaults
         * @param options
         * @returns {*}
         */
        function quiz(defaults, options) {
            return $resource('/api/quiz/v1/:id', {}, {quiz: {}})
                .quiz(defaults, options);
        }
    }

}());
