
(function () {
    'use strict';

    angular.module('cla.poll')
        .service('pollRedirect', pollRedirect);

    pollRedirect.$inject = ['growl.service', '$window'];

    function pollRedirect(growlService, $window) {
        var service = {
            pollUrl: pollUrl,
            redirect: redirect,
            toPoll: toPoll,
            toPollList: toPollList,
            toPollFinish: toPollFinish
        };

        return service;

        /**
         * Get the path for a poll.
         *
         * @param {int} poll_id
         * @returns {string}
         */
        function pollUrl(poll_id) {
            return '/polls-surveys/poll/' + poll_id;
        }

        /**
         * Redirect to the given path, optionally with a message and error flag.
         *
         * @param {string} pathname
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function redirect(pathname, message, is_error) {

            if (!message) {
                $window.location.pathname = pathname;

                return;
            }

            growlService.flash(message, null, is_error, pathname);
        }

        /**
         * Redirect to a poll's intro page.
         *
         * @param {int} poll_id
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toPoll(poll_id, message, is_error) {
            service.redirect(pollUrl(poll_id), message, is_error);
        }

        /**
         * Redirect to the poll list page.
         *
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toPollList(message, is_error) {
            service.redirect('/polls-surveys', message, is_error);
        }

        function toPollFinish(poll_id,) {
            service.redirect(pollUrl(poll_id) + '#/finish');
        }
    }
}());
