<?php
namespace Claromentis\Quiz\Search\Indexing;

$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] ?: array()) + array("_feb9037589181b" . "c30fa0f1cf78b9f" . "056" => base64_decode("dGl0bGU" . "="), "_f73dab606630b388645c4f7" . "d3fbb13bb" => base64_decode("YXJyYXlfbWVyZ2U" . "="), "_4d707fab93bebb00bbe" . "69e8159697c90" => base64_decode(""), "_809a58dc73011" . "173c031a53c0b4" . "0ef0e" => base64_decode("cHJvcGVyd" . "Gllcw=="), "_646df530340668323d9a8e" . "6c9204fe75" => base64_decode("aW1h" . "Z2Vf" . "c3Jj"), "_66824e0309bb76c78bd2bbd5f" . "da8d3d8" => base64_decode("c3Ry" . "aW5n"), "_8e7f4b5c8440c0a24fb1b632eee28" . "538" => base64_decode("YWN0" . "aW9u"), "_7aefd482de7885f4293c2926df28" . "c235" => base64_decode("anNvbl" . "9lbmNv" . "ZGU="), "_b15aac3" . "aa29c10e" . "a6d1228f" . "58cb9a7e" . "8" => base64_decode("b2JqZ" . "WN0"), "_fa96cdf58bff3b0695fb2bc0803d7" . "b12" => base64_decode("IGRvZXMgbm90IGV4aX" . "N0"), "_6ebc0afe64bb119ce3df66d" . "2745d8c38" => base64_decode("IGlzIG5vdCBMaXZlLCBzbyBpdCB3aWxsIG5vdCBiZSBpb" . "mRleGVk"), "_aa7e860" . "da1acd4e" . "767e0df9" . "d7d40738" . "0" => base64_decode("ZGF0" . "ZV9j" . "cmVh" . "dGVk"), "_b0eaaa9541f" . "479b4891f616" . "1117437b9" => base64_decode("cXVldWVfZnVsbF9y" . "ZWluZGV4"), "_5296e137570b" . "02bad64c772bd" . "9d734de" => base64_decode("VW5rbm93biBzcGVjaWFsIGFjdGlvbiBmb3" . "IgUXVpeiBpbmRleGluZzog"), "_e03f4261110db60749f3b" . "7cd2c23777f" => base64_decode("UX" . "Vp" . "ei" . "A="), "permiss" . "ions" => base64_decode("cGVybW" . "lzc2lv" . "bnM="), "_d34599daeb8cca" . "374d3adb38b2458" . "39c" => base64_decode("Y29udGVudHM" . "="), "_d43b1a885195a4b6ccc7d38ba3fcb1" . "f9" => base64_decode("Z2x5cGhpY2" . "9u"), "_dadf790baf241af" . "ac942824c1e6e37c" . "4" => base64_decode("dHlwZQ=" . "="), "_8e7b0b07b8da9d5cbd9a41129b62940" . "0" => base64_decode("ZGF0ZV9kZXRlY3Rpb" . "24="), "_99cee2d2272a8550f4b21e3c" . "b57fff7d" => base64_decode("ZW5" . "hYm" . "xlZ" . "A=="), "_31767d7ad58e" . "706dbf47b7a51" . "a0fe6c4" => base64_decode("Y291bn" . "Q="), "_d7bc4f88" . "3b1e96e6f" . "534b781de" . "dddd6b" => base64_decode("Z2x5cGhpY29ucyBnbHlwaGljb25zL" . "XF1ZXN0aW9uLXNpZ24="), "_df49a98e6130f798" . "876ecbf6bddc70d9" => base64_decode("UXVpeiB3aXRo" . "IElEIA=="), "_8ac93b48" . "4d7470c59" . "e32762064" . "6e2d1e" => base64_decode("X3NvdXJjZQ=" . "="), "_07954ed0fb988" . "65511b46872442" . "75502" => base64_decode("cXVpei9jb3Zlcn" . "M="), "_d0acf63c20abded6f" . "7458ea8e7009e96" => base64_decode("SW5zdHJ1Y3Rpb24gb2JqZWN0IElEIG" . "5vdCBmb3VuZCBmb3IgUXVpeg=="), "_33de78378f32407b8" . "52c241ec52f9a35" => base64_decode("aHJlZg=" . "="), "_2b2fdacf7b152cff4f3819c30fd5" . "8b1a" => base64_decode("L3F1aX" . "ov"));
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\CDN\CDNInterface;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Quiz\Model\Quiz;
use Claromentis\Quiz\Permissions\QuizAdminPermissions;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository\QuizRepository;
use Claromentis\Search\FieldType\TypeContents;
use Claromentis\Search\FieldType\TypeDate;
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Exception\IndexingException;
use Claromentis\Search\Indexing\Exception\NothingToIndexException;
use Claromentis\Search\Indexing\Exception\ObjectNotFoundException;
use Claromentis\Search\Indexing\Exception\UnsupportedOperationException;
use Claromentis\Search\Indexing\IndexingInstruction;
use Claromentis\Search\Indexing\IndexingItemInterface;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\Permissions as SearchPermissions;
use ClaText;
use Permissions;




class QuizIndexing implements IndexingItemInterface
{
    const TYPE_NAME = 'quiz';
    
    
    protected $cdn;
    
    
    protected $cla_text;
    
    
    protected $quiz_repo;
    
    
    protected $acl_repo;
    public function __construct(CDNInterface $cdn, \Claromentis\Core\TextUtil\ClaText $cla_text, QuizRepository $quiz_repo, AclRepository $_3436ad73cf80729d5a2e43d861c31e8b)
    {
        $this->cdn = $cdn;
        $this->cla_text = $cla_text;
        $this->quiz_repo = $quiz_repo;
        $this->acl_repo = $_3436ad73cf80729d5a2e43d861c31e8b;
    }
    
    
    
    
    
    
    public function InitMapping(ClientInterface $_87419315d6aaaec7dd2250b14245566e)
    {
        $_87419315d6aaaec7dd2250b14245566e->AddMapping(self::TYPE_NAME, [$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_8ac93b484d7470c" . "59e327620646e2d1" . "e"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_99cee2d2272a8550f4b21e3cb57ff" . "f7d"] => true], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_8e7b0b07b8da9d" . "5cbd9a41129b629" . "400"] => true, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_809a58dc73011173c0" . "31a53c0b40ef0e"] => [$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_feb9037589181bc30f" . "a0f1cf78b9f056"] => [$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dadf790baf241a" . "fac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_66824e0309bb76c" . "78bd2bbd5fda8d3d" . "8"]], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_33de78378f32407b852c241ec52" . "f9a35"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_dadf790baf241af" . "ac942824c1e6e37c" . "4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_66824e0309bb76c78b" . "d2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_99cee2d2272a8550" . "f4b21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_646df530340668323d9a8e6c9204" . "fe75"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_dadf790baf241afac94282" . "4c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_66824e0309bb76c" . "78bd2bbd5fda8d3d" . "8"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_99cee2d2272a8550f4b21" . "e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_d43b1a885195a" . "4b6ccc7d38ba3f" . "cb1f9"] => [$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_dadf790baf241afac9428" . "24c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_66824e030" . "9bb76c78bd" . "2bbd5fda8d" . "3d8"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_99cee2d2272a8550" . "f4b21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d34599daeb8cca374d3adb38b24583" . "9c"] => TypeContents::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_aa7e860da1a" . "cd4e767e0df9" . "d7d407380"] => TypeDate::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["per" . "mis" . "sio" . "ns"] => array($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_dadf790baf241a" . "fac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_b15aac3aa29c10ea6d1228f58c" . "b9a7e8"], $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_809a58dc7301" . "1173c031a53c0" . "b40ef0e"] => SearchPermissions::GetPropertiesMapping())]]);
    }
    
    
    
    
    
    
    
    public function Index(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_d0acf63c20abded6f7458ea8" . "e7009e96"]);
        }
        
        
        
        
        $_8652ba33e6ffeba02459fa9cbb320851 = $this->quiz_repo;
        try {
            
            
            
            
            $quiz = $_8652ba33e6ffeba02459fa9cbb320851->Get($_8c5f17e2e918145535955f8a633b6c7b->object_id);
        } catch (NotFoundException $_c35473364fa7a050299058f332ec29c1) {
            throw new ObjectNotFoundException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_df49a98e6130f" . "798876ecbf6bdd" . "c70d9"] . $_8c5f17e2e918145535955f8a633b6c7b->object_id . $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_fa96cdf58bff3b0695fb2" . "bc0803d7b12"]);
        }
        
        
        if (!$quiz->IsLive()) {
            throw new NothingToIndexException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_e03f4261110db60749f3b7cd2" . "c23777f"] . $quiz->id . $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_6ebc0afe64bb119ce3df66d2745d" . "8c38"]);
        }
        
        
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = $this->GetIndexData($quiz);
        $_87419315d6aaaec7dd2250b14245566e->Index(self::TYPE_NAME, $quiz->id, $_a6fb9cc38e2b15d5b2d8171e60aa3cbe);
    }
    
    
    
    
    
    
    protected function GetIndexData(Quiz $quiz)
    {
        $_6137f6b1054c046b6733dcd025f03c02 = $quiz->GetImage($this->cdn, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_07954ed0fb98" . "865511b468724" . "4275502"]);
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = [$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_feb9037589181bc30fa0f1cf78" . "b9f056"] => $quiz->title, $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_33de78378f32407b" . "852c241ec52f9a35"] => $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_2b2fdacf7b152cff4f38" . "19c30fd58b1a"] . $quiz->id, $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_646df530340668323d9a8e6c9204" . "fe75"] => $_6137f6b1054c046b6733dcd025f03c02, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_d34599daeb8cca374" . "d3adb38b245839c"] => $this->cla_text->BBCode2Plain((string) $quiz->description), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_aa7e860da1acd4e767e0df9d7d40" . "7380"] => TypeDate::Format($quiz->created_date), $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["per" . "mis" . "sio" . "ns"] => $this->GetPermissionsIndexData($quiz)];
        if ($_6137f6b1054c046b6733dcd025f03c02 === $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_4d707fab93beb" . "b00bbe69e81596" . "97c90"]) {
            $_a6fb9cc38e2b15d5b2d8171e60aa3cbe[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d43b1a885195" . "a4b6ccc7d38ba" . "3fcb1f9"]] = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_d7bc4f883b1e96e6f534b781ded" . "ddd6b"];
        }
        return $_a6fb9cc38e2b15d5b2d8171e60aa3cbe;
    }
    
    
    
    
    
    
    
    protected function GetPermissionsIndexData(Quiz $quiz)
    {
        
        
        $permissions = new Permissions(QuizPermissions::CLASS_QUIZ, $quiz->id);
        $permissions->Load();
        $_665240f1a489ba897ccc8ace510a47cb = new Permissions(QuizAdminPermissions::CLASS_QUIZ_ADMIN, 1);
        $_665240f1a489ba897ccc8ace510a47cb->Load();
        
        
        $_c9dab5b1c7628cf9721eea495ec5d40b = $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_f73dab606630b388645c4f7d3f" . "bb13bb"]($_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_MANAGE_ALL), $_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_VIEW_ALL_STATISTICS));
        
        
        foreach ($_c9dab5b1c7628cf9721eea495ec5d40b as $_c4d674abe9291be143b224c411958fcf) {
            list($_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d) = $_c4d674abe9291be143b224c411958fcf;
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, $_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d);
        }
        
        
        $_f053e79538903e098fb90b42736274df = QuizAdminPermissions::CanManageOwn($this->acl_repo, SecurityContext::CreateForUser($quiz->created_by));
        if ($_f053e79538903e098fb90b42736274df) {
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, PermOClass::INDIVIDUAL, $quiz->created_by);
        }
        
        
        $_5572df110aae46854e281078ba4712b2 = new SearchPermissions();
        return $_5572df110aae46854e281078ba4712b2->GetIndexDataSimple($permissions);
    }
    
    
    
    
    
    
    public function Delete(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        
        
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            return;
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Delete(self::TYPE_NAME, $_8c5f17e2e918145535955f8a633b6c7b->object_id);
    }
    
    
    
    
    
    
    protected function GetAllQuizIds()
    {
        return $this->quiz_repo->ListQuizIds(false);
    }
    
    
    
    
    
    
    public function QueueFullIndex()
    {
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Index(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_31767d7ad58e706dbf47b7a51a0fe" . "6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    public function QueueFullReindex($_4433a5922f5df0ebd8436fbb431e146c)
    {
        if (!$_4433a5922f5df0ebd8436fbb431e146c) {
            return $this->QueueFullIndex();
        }
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Reindex(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_31767d7ad58e706dbf47b7a51a0" . "fe6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    
    public function Special(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        $_8e7f4b5c8440c0a24fb1b632eee28538 = $_8c5f17e2e918145535955f8a633b6c7b->extra[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8e7f4b5c8440c0a" . "24fb1b632eee2853" . "8"]];
        if ($_8e7f4b5c8440c0a24fb1b632eee28538 !== $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_b0eaaa9541f" . "479b4891f616" . "1117437b9"]) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_5296e137570b02bad64c772bd9d734d" . "e"] . $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_7aefd482de7885f4293c2926df28c" . "235"]($_8c5f17e2e918145535955f8a633b6c7b->extra));
        }
        $this->QueueFullReindex(true);
    }
}