<?php
namespace Claromentis\Quiz\Search\Indexing;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] ?: array()) + array("_b0eaaa9541f479b4" . "891f6161117437b9" => base64_decode("cXVldWVfZnVsbF9yZWl" . "uZGV4"), "_b15aac3aa29c10ea6d1228f58" . "cb9a7e8" => base64_decode("b2JqZ" . "WN0"), "_feb90375891" . "81bc30fa0f1c" . "f78b9f056" => base64_decode("dGl0bG" . "U="), "_945e7f1" . "80f5ac7c" . "426fa3d9" . "2712223a" . "3" => base64_decode("VW5rbm93biBzcGVjaWFs" . "IGFjdGlvbiBmb3IgU3Vy" . "dmV5cyBpbmRleGluZzog"), "_aa7e860da1acd4e76" . "7e0df9d7d407380" => base64_decode("ZGF0ZV9jcmVh" . "dGVk"), "_d43b1a885195a4b6ccc" . "7d38ba3fcb1f9" => base64_decode("Z2x5" . "cGhp" . "Y29u"), "_33de78378f32407" . "b852c241ec52f9a3" . "5" => base64_decode("aHJlZ" . "g=="), "_66824e0309bb76c78bd2b" . "bd5fda8d3d8" => base64_decode("c3Rya" . "W5n"), "_f73dab606630b388645c4f7d3fbb13b" . "b" => base64_decode("YXJy" . "YXlf" . "bWVy" . "Z2U="), "_8e7b0b07b8da9d5cbd9a4112" . "9b629400" => base64_decode("ZGF0ZV" . "9kZXRl" . "Y3Rpb2" . "4="), "_6596b8f6a4969f9a3" . "f6a1b22b90e9331" => base64_decode("c3ByaW50Zg=" . "="), "_8ac93b484d7470c59e" . "327620646e2d1e" => base64_decode("X3Nv" . "dXJj" . "ZQ=="), "_4d707fab93beb" . "b00bbe69e81596" . "97c90" => base64_decode(""), "_74d414041" . "96e33a2a11" . "ac3f813c15" . "5b7" => base64_decode("Z2x5cGhpY29ucyBnbHlw" . "aGljb25zLXBvbGxzLXN1" . "cnZleQ=="), "_1701bcec3c1" . "ce0841f0b67a" . "74e766bcb" => base64_decode("U3VydmV5IHdpdGgg" . "SUQgJXMgZG9lcyBu" . "b3QgZXhpc3Q="), "permissio" . "ns" => base64_decode("cGVy" . "bWlz" . "c2lv" . "bnM="), "_8e7f4b5c8440c0a24fb1b632eee28" . "538" => base64_decode("YWN0aW" . "9u"), "_c05fc248d5ab54ad876be" . "7ab77eb8fa7" => base64_decode("L3BvbGxzLXN1cn" . "ZleXMvc3VydmV5" . "Lw=="), "_dadf790baf24" . "1afac942824c1" . "e6e37c4" => base64_decode("dHlwZQ=" . "="), "_7aefd482de7885f4293c2926df" . "28c235" => base64_decode("anNvbl9lbm" . "NvZGU="), "_bc60b6b4ed7cd96f215c39" . "8b7974e744" => base64_decode("U3VydmV5ICVzIGlzIG5vdCBMaXZlLCBzbyBpdCB3aWxsI" . "G5vdCBiZSBpbmRleGVk"), "_f521e6d29ae6e6c84ef8eb3270" . "ff440d" => base64_decode("cXVpei9zdXJ2ZXkvY2" . "92ZXJz"), "_33f09d76394b074b779265f857" . "d5ec8a" => base64_decode("Y291bnRfc2FmZ" . "Q=="), "_402d65541d509737cc4cc962c69604" . "3e" => base64_decode("SW5zdHJ1Y3Rpb24g" . "b2JqZWN0IElEIG5v" . "dCBmb3VuZCBmb3Ig" . "U3VydmV5"), "_d34599daeb8cca374d3ad" . "b38b245839c" => base64_decode("Y29" . "udG" . "Vud" . "HM="), "_809a58dc73011173c031a53c0b40" . "ef0e" => base64_decode("cHJvc" . "GVydG" . "llcw=" . "="), "_646df5303406683" . "23d9a8e6c9204fe7" . "5" => base64_decode("aW1hZ2Vf" . "c3Jj"), "_99cee2d2272a8550f4b21e3cb" . "57fff7d" => base64_decode("ZW5hYm" . "xlZA=="));
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\CDN\CDNInterface;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Quiz\Model\Survey;
use Claromentis\Quiz\Permissions\SurveyAdminPermissions;
use Claromentis\Quiz\Permissions\SurveyPermissions;
use Claromentis\Quiz\Repository\SurveyRepository;
use Claromentis\Search\FieldType\TypeContents;
use Claromentis\Search\FieldType\TypeDate;
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Exception\IndexingException;
use Claromentis\Search\Indexing\Exception\NothingToIndexException;
use Claromentis\Search\Indexing\Exception\ObjectNotFoundException;
use Claromentis\Search\Indexing\Exception\UnsupportedOperationException;
use Claromentis\Search\Indexing\IndexingInstruction;
use Claromentis\Search\Indexing\IndexingItemInterface;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\Permissions as SearchPermissions;
use Claromentis\Core\TextUtil\ClaText;
use Permissions;




class SurveyIndexing implements IndexingItemInterface
{
    const TYPE_NAME = 'survey';
    
    
    private $cla_text;
    
    
    private $cdn;
    
    
    private $survey_repository;
    
    
    private $survey_admin_permissions;
    public function __construct(ClaText $cla_text, CDNInterface $cdn, SurveyRepository $_d788c955b64166f591e5ce0a44478441, SurveyAdminPermissions $survey_admin_permissions)
    {
        $this->cla_text = $cla_text;
        $this->cdn = $cdn;
        $this->survey_repository = $_d788c955b64166f591e5ce0a44478441;
        $this->survey_admin_permissions = $survey_admin_permissions;
    }
    
    
    
    
    
    
    public function InitMapping(ClientInterface $_87419315d6aaaec7dd2250b14245566e)
    {
        $_87419315d6aaaec7dd2250b14245566e->AddMapping(self::TYPE_NAME, [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8ac93b484d7470c59e32" . "7620646e2d1e"] => [$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_99cee2d227" . "2a8550f4b21" . "e3cb57fff7d"] => true], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_8e7b0b07b8da9d5cbd" . "9a41129b629400"] => true, $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_809a58dc73011173c031" . "a53c0b40ef0e"] => [$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_feb9037589181bc30fa" . "0f1cf78b9f056"] => [$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_dadf790baf241afac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_66824e0309bb76c78bd2bbd5fda8d" . "3d8"]], $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_33de78378f32407b852c241ec" . "52f9a35"] => [$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dadf790baf241afac942824c1e" . "6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_66824e0309bb76" . "c78bd2bbd5fda8d" . "3d8"], $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_99cee2d2272a8550" . "f4b21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_646df530340668" . "323d9a8e6c9204f" . "e75"] => [$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_dadf790baf241afac942824c1e6e" . "37c4"] => $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_66824e0" . "309bb76c" . "78bd2bbd" . "5fda8d3d" . "8"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_99cee2d2272a8550f" . "4b21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_d43b1a885195a4b6ccc7d38ba3fcb1" . "f9"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_dadf790baf241afac942824c" . "1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_66824e0309bb76c78bd2bbd5" . "fda8d3d8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_99cee2d2272a8550f4b21e3cb57" . "fff7d"] => false], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_d34599daeb8cca374d3a" . "db38b245839c"] => TypeContents::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_aa7e860da1acd4e767e0df9d7d40738" . "0"] => TypeDate::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["per" . "mis" . "sio" . "ns"] => [$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dadf790" . "baf241af" . "ac942824" . "c1e6e37c" . "4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_b15aac3aa29c1" . "0ea6d1228f58cb" . "9a7e8"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_809a58dc730111" . "73c031a53c0b40e" . "f0e"] => SearchPermissions::GetPropertiesMapping()]]]);
    }
    
    
    
    
    
    
    
    
    
    public function Index(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_402d65541d509737" . "cc4cc962c696043e"]);
        }
        try {
            
            
            $survey = $this->survey_repository->Get($_8c5f17e2e918145535955f8a633b6c7b->object_id);
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new ObjectNotFoundException($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_6596b8f6" . "a4969f9a3" . "f6a1b22b9" . "0e9331"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_1701bcec3c1ce08" . "41f0b67a74e766bc" . "b"], $_8c5f17e2e918145535955f8a633b6c7b->object_id));
        }
        if (!$survey->IsLive()) {
            throw new NothingToIndexException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_6596b8f6a4969f9a3f6a1b2" . "2b90e9331"]($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_bc60b6b4ed7cd96f215c398b7974e7" . "44"], $survey->id));
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Index(self::TYPE_NAME, $survey->id, $this->GetIndexData($survey));
    }
    
    
    
    
    
    
    
    
    protected function GetIndexData(Survey $survey)
    {
        $_6137f6b1054c046b6733dcd025f03c02 = $survey->GetImage($this->cdn, $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f521e6d29ae6e6" . "c84ef8eb3270ff4" . "40d"]);
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = [$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_feb9037589181bc30" . "fa0f1cf78b9f056"] => $survey->title, $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_33de78378f32" . "407b852c241ec" . "52f9a35"] => $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_c05fc248d5ab54ad" . "876be7ab77eb8fa7"] . $survey->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_646df5303406" . "68323d9a8e6c9" . "204fe75"] => $_6137f6b1054c046b6733dcd025f03c02, $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d34599daeb" . "8cca374d3ad" . "b38b245839c"] => $this->cla_text->BBCode2Plain($survey->description ?: $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_4d707fab93bebb00bbe69e81596" . "97c90"]), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_aa7e860" . "da1acd4e" . "767e0df9" . "d7d40738" . "0"] => TypeDate::Format($survey->created_date), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["perm" . "issi" . "ons"] => $this->GetPermissionsIndexData($survey)];
        if ($_6137f6b1054c046b6733dcd025f03c02 === $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_4d707fab93bebb00bbe69e815" . "9697c90"]) {
            $_a6fb9cc38e2b15d5b2d8171e60aa3cbe[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_d43b1a8851" . "95a4b6ccc7d" . "38ba3fcb1f9"]] = $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_74d41404" . "196e33a2a" . "11ac3f813" . "c155b7"];
        }
        return $_a6fb9cc38e2b15d5b2d8171e60aa3cbe;
    }
    
    
    
    
    
    
    
    protected function GetPermissionsIndexData(Survey $survey)
    {
        
        
        $permissions = new Permissions(SurveyPermissions::CLASS_SURVEY, $survey->id);
        $_665240f1a489ba897ccc8ace510a47cb = new Permissions(SurveyAdminPermissions::CLASS_SURVEY_ADMIN, 1);
        $permissions->Load();
        $_665240f1a489ba897ccc8ace510a47cb->Load();
        
        
        $_c9dab5b1c7628cf9721eea495ec5d40b = $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_f73dab606630b3886" . "45c4f7d3fbb13bb"]($_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(SurveyAdminPermissions::PERM_VIEW_RESULTS), $_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(SurveyAdminPermissions::PERM_MANAGE_ALL));
        
        
        foreach ($_c9dab5b1c7628cf9721eea495ec5d40b as $_c4d674abe9291be143b224c411958fcf) {
            list($_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d) = $_c4d674abe9291be143b224c411958fcf;
            $permissions->Add(SurveyPermissions::PERM_TAKE, $_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d);
        }
        
        
        $_f053e79538903e098fb90b42736274df = $this->survey_admin_permissions->CanManageOwn(SecurityContext::CreateForUser($survey->created_by));
        if ($_f053e79538903e098fb90b42736274df) {
            $permissions->Add(SurveyPermissions::PERM_TAKE, PermOClass::INDIVIDUAL, $survey->created_by);
        }
        
        
        $_5572df110aae46854e281078ba4712b2 = new SearchPermissions();
        return $_5572df110aae46854e281078ba4712b2->GetIndexDataSimple($permissions);
    }
    
    
    
    
    
    
    public function Delete(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        
        
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            return;
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Delete(self::TYPE_NAME, $_8c5f17e2e918145535955f8a633b6c7b->object_id);
    }
    
    
    
    
    
    
    protected function GetAllSurveyIds()
    {
        return $this->survey_repository->ListAllSurveyIds();
    }
    
    
    
    
    
    
    public function QueueFullIndex()
    {
        $_21251b5cbf8c4f9d4d56281f4886036f = $this->GetAllSurveyIds();
        foreach ($_21251b5cbf8c4f9d4d56281f4886036f as $survey_id) {
            IndexingQueue::Index(self::TYPE_NAME, $survey_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_33f09d76394b074b779265f85" . "7d5ec8a"]($_21251b5cbf8c4f9d4d56281f4886036f);
    }
    
    
    
    
    
    
    
    public function QueueFullReindex($_4433a5922f5df0ebd8436fbb431e146c)
    {
        if (!$_4433a5922f5df0ebd8436fbb431e146c) {
            return $this->QueueFullIndex();
        }
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllSurveyIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Reindex(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_33f09d76394b074b779" . "265f857d5ec8a"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    
    public function Special(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        $_8e7f4b5c8440c0a24fb1b632eee28538 = $_8c5f17e2e918145535955f8a633b6c7b->extra[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_8e7f4b5c8440c0" . "a24fb1b632eee28" . "538"]];
        if ($_8e7f4b5c8440c0a24fb1b632eee28538 !== $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_b0eaaa9541f479b4891f6161117" . "437b9"]) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_945e7f180f5ac7c426fa3" . "d92712223a3"] . $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_7aefd482de7885f4293c" . "2926df28c235"]($_8c5f17e2e918145535955f8a633b6c7b->extra));
        }
        $this->QueueFullReindex(true);
    }
}