/**
 * Application initialization - survey
 *
 */
define([
    'cla_angular',
    'ng.cla.core.growl',
    'ng.cla.core.lmsg',
    'datatable',
    'ng.cla.core.share'
], function (angular) {
    // angular defined by imports-loader
    angular.module('cla.survey', ['cla.core.growl', 'cla.core.lmsg', 'cla.core.datatable', 'cla.core.share', 'ngResource', 'ngRoute', 'ngSanitize'])
        .config(['$routeProvider', '$locationProvider', function ($routeProvider, $locationProvider) {
            $locationProvider.hashPrefix('');

            $routeProvider.when('/', {
                    controller: 'introController',
                    templateUrl: '/intranet/quiz/html/templates/survey/intro.html'
                })

                .when('/start|/continue', {
                    controller: 'startController',
                    templateUrl: '/intranet/quiz/html/templates/survey/section.html'
                })

                .when('/finish/:attempt|/finish', {
                    controller: 'finishController',
                    templateUrl: '/intranet/quiz/html/templates/survey/finish.html'
                })

                .when('/review', {
                    controller: 'reviewController',
                    templateUrl: '/intranet/quiz/html/templates/survey/review.html'
                })

                .when('/results/individual', {
                    controller: 'resultController',
                    templateUrl: '/intranet/quiz/html/templates/survey/result.html'
                })

                .when('/results/individual/:attempt', {
                    controller: 'resultController',
                    templateUrl: '/intranet/quiz/html/templates/survey/result.html'
                })

                .when('/results', {
                    redirectTo: () => {
                        window.location.href =  window.location.href.replace('#', '');
                    }
                })

                .otherwise({
                    redirectTo: () => window.location.href = '/polls-surveys?message=survey does not exist&is_error_message=1'
                })
        }])
});
