<?php
namespace Claromentis\Quiz\Search\Indexing;

$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array("_5296e13757" . "0b02bad64c7" . "72bd9d734de" => base64_decode("VW5rbm93biBzcGVjaWFs" . "IGFjdGlvbiBmb3IgUXVp" . "eiBpbmRleGluZzog"), "_31767d7ad58e706d" . "bf47b7a51a0fe6c4" => base64_decode("Y2" . "91" . "bn" . "Q="), "_809a58dc73" . "011173c031a" . "53c0b40ef0e" => base64_decode("cHJvc" . "GVydG" . "llcw=" . "="), "_33de78378f" . "32407b852c2" . "41ec52f9a35" => base64_decode("aHJlZ" . "g=="), "_d0acf63c20abded6f7458e" . "a8e7009e96" => base64_decode("SW5zdHJ1Y3Rpb24gb2JqZW" . "N0IElEIG5vdCBmb3VuZCBm" . "b3IgUXVpeg=="), "_8ac93b48" . "4d7470c59" . "e32762064" . "6e2d1e" => base64_decode("X3NvdXJjZ" . "Q=="), "_99cee2d2272a8550" . "f4b21e3cb57fff7d" => base64_decode("ZW5hYmxlZ" . "A=="), "perm" . "issi" . "ons" => base64_decode("cGVy" . "bWlz" . "c2lv" . "bnM="), "_b15aac3aa29c10ea6" . "d1228f58cb9a7e8" => base64_decode("b2Jq" . "ZWN0"), "_feb9037589181bc30fa0f1c" . "f78b9f056" => base64_decode("dGl0b" . "GU="), "_d7bc4f883b1e96e6f534b" . "781dedddd6b" => base64_decode("Z2x5cGhpY29ucyBnbHlwaGljb25zLXF1ZXN0a" . "W9uLXNpZ24="), "_66824e0309bb76c78bd2bbd5fda8d3" . "d8" => base64_decode("c3R" . "yaW" . "5n"), "_e03f4261110db60749" . "f3b7cd2c23777f" => base64_decode("UX" . "Vp" . "ei" . "A="), "_646df530340668323d9a8e6c920" . "4fe75" => base64_decode("aW1h" . "Z2Vf" . "c3Jj"), "_d34599daeb8cca374d3adb38b2" . "45839c" => base64_decode("Y29u" . "dGVu" . "dHM="), "_7aefd482" . "de7885f42" . "93c2926df" . "28c235" => base64_decode("anNv" . "bl9l" . "bmNv" . "ZGU="), "_8e7f4b5c8440c0" . "a24fb1b632eee28" . "538" => base64_decode("YWN0a" . "W9u"), "_d43b1a885195a4b6ccc7d" . "38ba3fcb1f9" => base64_decode("Z2x5" . "cGhp" . "Y29u"), "_b0eaaa9541f479b48" . "91f6161117437b9" => base64_decode("cXVldWVfZnVsbF9yZWlu" . "ZGV4"), "_f73dab6" . "06630b38" . "8645c4f7" . "d3fbb13b" . "b" => base64_decode("YXJyYXlfbW" . "VyZ2U="), "_2b2fdacf7b152cf" . "f4f3819c30fd58b1" . "a" => base64_decode("L3F1aXo" . "v"), "_aa7e860da1acd4e767e0df9d7d4" . "07380" => base64_decode("ZGF0ZV9j" . "cmVhdGVk"), "_07954ed0fb9886551" . "1b4687244275502" => base64_decode("cXVpei9jb" . "3ZlcnM="), "_8e7b0b07b8da9d5cbd9a41129b6" . "29400" => base64_decode("ZGF0ZV9kZXRlY3Rpb2" . "4="), "_fa96cdf58" . "bff3b0695f" . "b2bc0803d7" . "b12" => base64_decode("IGRvZXMgb" . "m90IGV4aX" . "N0"), "_df49a98e6130" . "f798876ecbf6b" . "ddc70d9" => base64_decode("UXVpeiB3aXRoIElEIA" . "=="), "_4d707fab93bebb00bb" . "e69e8159697c90" => base64_decode(""), "_6ebc0afe64bb119ce3df66d2" . "745d8c38" => base64_decode("IGlzIG5vdCBMaXZlLCBzbyBpdCB3aWxsIG5vdCBiZS" . "BpbmRleGVk"), "_dadf790baf241af" . "ac942824c1e6e37c" . "4" => base64_decode("dHl" . "wZQ" . "=="));
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\CDN\CDNInterface;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Quiz\Model\Quiz;
use Claromentis\Quiz\Permissions\QuizAdminPermissions;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository\QuizRepository;
use Claromentis\Search\FieldType\TypeContents;
use Claromentis\Search\FieldType\TypeDate;
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Exception\IndexingException;
use Claromentis\Search\Indexing\Exception\NothingToIndexException;
use Claromentis\Search\Indexing\Exception\ObjectNotFoundException;
use Claromentis\Search\Indexing\Exception\UnsupportedOperationException;
use Claromentis\Search\Indexing\IndexingInstruction;
use Claromentis\Search\Indexing\IndexingItemInterface;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\Permissions as SearchPermissions;
use ClaText;
use Permissions;




class QuizIndexing implements IndexingItemInterface
{
    const TYPE_NAME = 'quiz';
    
    
    protected $cdn;
    
    
    protected $cla_text;
    
    
    protected $quiz_repo;
    
    
    protected $acl_repo;
    public function __construct(CDNInterface $cdn, \Claromentis\Core\TextUtil\ClaText $cla_text, QuizRepository $quiz_repo, AclRepository $_3436ad73cf80729d5a2e43d861c31e8b)
    {
        $this->cdn = $cdn;
        $this->cla_text = $cla_text;
        $this->quiz_repo = $quiz_repo;
        $this->acl_repo = $_3436ad73cf80729d5a2e43d861c31e8b;
    }
    
    
    
    
    
    
    public function InitMapping(ClientInterface $_87419315d6aaaec7dd2250b14245566e)
    {
        $_87419315d6aaaec7dd2250b14245566e->AddMapping(self::TYPE_NAME, [$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_8ac93b484d" . "7470c59e327" . "620646e2d1e"] => [$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_99cee2d2272a8550f4b21e" . "3cb57fff7d"] => true], $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_8e7b0b07b8da9d5cbd9a" . "41129b629400"] => true, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_809a58dc73011173" . "c031a53c0b40ef0e"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_feb9037589181b" . "c30fa0f1cf78b9f" . "056"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_dadf790baf241afac942824c1" . "e6e37c4"] => $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_66824e03" . "09bb76c78" . "bd2bbd5fd" . "a8d3d8"]], $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_33de78378f32407b852c241ec52f9a" . "35"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_dadf790baf241afac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_66824e0309bb76c78bd" . "2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_99cee2d2272a8550f4b" . "21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_646df530340668323d9a8e6c9204fe" . "75"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_dadf790baf241afac942824c1e6" . "e37c4"] => $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_66824e0309bb76c78" . "bd2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_99cee2d22" . "72a8550f4b" . "21e3cb57ff" . "f7d"] => false], $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_d43b1a885195a4b6ccc7d38ba3fcb1" . "f9"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_dadf790baf241afac942824" . "c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_66824e0309bb76c78" . "bd2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_99cee2d2272a8550f4" . "b21e3cb57fff7d"] => false], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_d34599daeb8cca374d3adb38b" . "245839c"] => TypeContents::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_aa7e860da1acd4e767e0df9d" . "7d407380"] => TypeDate::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["permissi" . "ons"] => array($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_dadf790baf241afac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_b15aac3aa29c10" . "ea6d1228f58cb9a" . "7e8"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_809a58dc73011173c031a53c0b40ef0" . "e"] => SearchPermissions::GetPropertiesMapping())]]);
    }
    
    
    
    
    
    
    
    public function Index(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_d0acf63c20abded6" . "f7458ea8e7009e96"]);
        }
        
        
        
        
        $_8652ba33e6ffeba02459fa9cbb320851 = $this->quiz_repo;
        try {
            
            
            
            
            $quiz = $_8652ba33e6ffeba02459fa9cbb320851->Get($_8c5f17e2e918145535955f8a633b6c7b->object_id);
        } catch (NotFoundException $_c35473364fa7a050299058f332ec29c1) {
            throw new ObjectNotFoundException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_df49a98e6130f798876" . "ecbf6bddc70d9"] . $_8c5f17e2e918145535955f8a633b6c7b->object_id . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_fa96cdf58bff" . "3b0695fb2bc08" . "03d7b12"]);
        }
        
        
        if (!$quiz->IsLive()) {
            throw new NothingToIndexException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_e03f4261110db6" . "0749f3b7cd2c237" . "77f"] . $quiz->id . $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_6ebc0afe64bb119ce3df66d2745" . "d8c38"]);
        }
        
        
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = $this->GetIndexData($quiz);
        $_87419315d6aaaec7dd2250b14245566e->Index(self::TYPE_NAME, $quiz->id, $_a6fb9cc38e2b15d5b2d8171e60aa3cbe);
    }
    
    
    
    
    
    
    protected function GetIndexData(Quiz $quiz)
    {
        $_6137f6b1054c046b6733dcd025f03c02 = $quiz->GetImage($this->cdn, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_07954ed0fb98865511b46" . "87244275502"]);
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = [$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_feb9037589181bc30fa0f1cf78" . "b9f056"] => $quiz->title, $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_33de78378f32407b852c2" . "41ec52f9a35"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_2b2fdacf7b152cff4" . "f3819c30fd58b1a"] . $quiz->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_646df53" . "03406683" . "23d9a8e6" . "c9204fe7" . "5"] => $_6137f6b1054c046b6733dcd025f03c02, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_d34599daeb8cca374d3" . "adb38b245839c"] => $this->cla_text->BBCode2Plain((string) $quiz->description), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_aa7e860da1acd4e7" . "67e0df9d7d407380"] => TypeDate::Format($quiz->created_date), $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["per" . "mis" . "sio" . "ns"] => $this->GetPermissionsIndexData($quiz)];
        if ($_6137f6b1054c046b6733dcd025f03c02 === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_4d707fab" . "93bebb00b" . "be69e8159" . "697c90"]) {
            $_a6fb9cc38e2b15d5b2d8171e60aa3cbe[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_d43b1a8" . "85195a4b" . "6ccc7d38" . "ba3fcb1f" . "9"]] = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d7bc4f883b1e9" . "6e6f534b781ded" . "ddd6b"];
        }
        return $_a6fb9cc38e2b15d5b2d8171e60aa3cbe;
    }
    
    
    
    
    
    
    
    protected function GetPermissionsIndexData(Quiz $quiz)
    {
        
        
        $permissions = new Permissions(QuizPermissions::CLASS_QUIZ, $quiz->id);
        $permissions->Load();
        $_665240f1a489ba897ccc8ace510a47cb = new Permissions(QuizAdminPermissions::CLASS_QUIZ_ADMIN, 1);
        $_665240f1a489ba897ccc8ace510a47cb->Load();
        
        
        $_c9dab5b1c7628cf9721eea495ec5d40b = $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_f73dab606630b388645c4f7d3fbb13b" . "b"]($_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_MANAGE_ALL), $_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_VIEW_ALL_STATISTICS));
        
        
        foreach ($_c9dab5b1c7628cf9721eea495ec5d40b as $_c4d674abe9291be143b224c411958fcf) {
            list($_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d) = $_c4d674abe9291be143b224c411958fcf;
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, $_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d);
        }
        
        
        $_f053e79538903e098fb90b42736274df = QuizAdminPermissions::CanManageOwn($this->acl_repo, SecurityContext::CreateForUser($quiz->created_by));
        if ($_f053e79538903e098fb90b42736274df) {
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, PermOClass::INDIVIDUAL, $quiz->created_by);
        }
        
        
        $_5572df110aae46854e281078ba4712b2 = new SearchPermissions();
        return $_5572df110aae46854e281078ba4712b2->GetIndexDataSimple($permissions);
    }
    
    
    
    
    
    
    public function Delete(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        
        
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            return;
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Delete(self::TYPE_NAME, $_8c5f17e2e918145535955f8a633b6c7b->object_id);
    }
    
    
    
    
    
    
    protected function GetAllQuizIds()
    {
        return $this->quiz_repo->ListQuizIds(false);
    }
    
    
    
    
    
    
    public function QueueFullIndex()
    {
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Index(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_31767d7ad58e706dbf47b7a51a0f" . "e6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    public function QueueFullReindex($_4433a5922f5df0ebd8436fbb431e146c)
    {
        if (!$_4433a5922f5df0ebd8436fbb431e146c) {
            return $this->QueueFullIndex();
        }
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Reindex(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_31767d7ad58e706dbf47b7a5" . "1a0fe6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    
    public function Special(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        $_8e7f4b5c8440c0a24fb1b632eee28538 = $_8c5f17e2e918145535955f8a633b6c7b->extra[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_8e7f4b5c8440c0a24fb1b632eee2853" . "8"]];
        if ($_8e7f4b5c8440c0a24fb1b632eee28538 !== $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_b0eaaa95" . "41f479b48" . "91f616111" . "7437b9"]) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_5296e1375" . "70b02bad64" . "c772bd9d73" . "4de"] . $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_7aefd482de7885f" . "4293c2926df28c23" . "5"]($_8c5f17e2e918145535955f8a633b6c7b->extra));
        }
        $this->QueueFullReindex(true);
    }
}