/**
 * Controls the taking of a survey
 */
(function () {
    'use strict';

    angular.module('cla.survey').controller('introController', introController);

    introController.$inject = ['$scope', '$window', 'surveyResources', 'surveyRedirect', 'moment', 'locale'];

    /**
     *
     * @param $scope
     * @param $window
     * @param surveyResources
     * @param surveyRedirect
     * @param moment
     * @param locale
     */
    function introController($scope, $window, surveyResources, surveyRedirect, moment, locale) {
        $scope.content = $window.survey_preload.survey;
        $scope.content.section_count = $window.survey_preload.section_count;
        $scope.localise = localise;
        $scope.isContinue = isContinue;
        $scope.isEnded = isEnded;
        $scope.hasEnd = hasEnd;
        $scope.isAttemptable = isAttemptable;
        $scope.isCompleted = isCompleted;
        $scope.isCompletedAnonymous = isCompletedAnonymous;
        $scope.showPreview = showPreview;

        $scope.survey_id = $window.survey_preload.survey.id;
        $scope.can_retake = false;
        $scope.preview = $window.survey_preload.preview;
        $scope.has_voted_anonymously = $window.survey_preload.has_voted_anonymously;
        $scope.anonymous = parseInt($scope.content.anonymous);
        $scope.data_ready = false;
        $scope.end_date_lmsg = '';
        $scope.edit_survey_lmsg = lmsg('quiz.polls-surveys.edit_survey');
        $scope.view_results_lmsg = lmsg('quiz.survey.info.view_results');

        init();

        /**
         * initialise controller, with routing
         */
        function init() {
            intro();
        }

        function intro() {
            $scope.content = $window.survey_preload;

            // Load more Survey data from the API
            surveyResources.getSurvey($window.survey_preload.survey.id).$promise
                .then(data => {
                    let questions_number = 0;

                    $scope.content = data;
                    $scope.attempts_count = data.attempts_count;
                    $scope.can_attempt = data.permissions.can_attempt;
                    $scope.can_retake = data.permissions.can_retake;
                    $scope.can_manage = data.permissions.can_manage;
                    $scope.can_preview = data.permissions.can_preview;
                    $scope.content.sections_number = data.survey.sections.length;

                    data.survey.sections.map(section => questions_number += section.questions.length);

                    $scope.content.questions_number = questions_number;
                    $scope.content.attempt_id = !!data.attempt ? data.attempt.id : null;
                    $scope.data_ready = true;

                    $scope.end_date_lmsg = prettyEndDate($scope.content.survey.end_date_js);
                    },

                res => surveyRedirect.toSurveyList(res.data.message, true)
            );
        }

        function prettyEndDate(date) {
            let date_obj = new Date(date);
            // moment library complains if we pass in the original (non-ISO) string
            const this_moment = moment(date_obj.toISOString());
            const time_string = this_moment.format(locale.time_format);
            const date_string = this_moment.format(locale.date_format_long);

            if (isToday(date_obj))
                return lmsg('quiz.survey.info.end_date_today', time_string);
            else if(isTomorrow(date_obj))
                return lmsg('quiz.survey.info.end_date_tomorrow', time_string);
            else
                return lmsg('quiz.survey.info.end_date', date_string);
        }

        function isToday(date) {
            const today = new Date();
            return date.getDate() === today.getDate() &&
                date.getMonth() === today.getMonth() &&
                date.getFullYear() === today.getFullYear()
        }

        function isTomorrow(date) {
            let tomorrow = new Date();
            tomorrow.setDate(tomorrow.getDate() + 1);
            return date.getDate() === tomorrow.getDate() &&
                date.getMonth() === tomorrow.getMonth() &&
                date.getFullYear() === tomorrow.getFullYear()
        }


        /**
         * localisation
         * @returns {string}
         */
        function localise() {
            return String.localise.apply(this, arguments);
        }

        /**
         * @returns {boolean}
         */
        function isContinue() {
            return $scope.content.attempt && !$scope.content.attempt.completed_date;
        }

        function isAttemptable() {
            return !!$scope.content.attempt
        }

        /**
         * @returns {boolean}
         */
        function hasEnd() {
            return !!$scope.content.survey.end_date;
        }

        function isEnded() {
            if (!$scope.content.survey.end_date) {
                return false
            }
            return new Date($scope.content.survey.end_date_js) < new Date()
        }

        function isCompleted() {
            return !!($scope.content.attempt && $scope.content.attempt.completed_date && !$scope.anonymous)
        }

        function isCompletedAnonymous() {
            return !!($scope.anonymous && $scope.has_voted_anonymously)
        }

        function showPreview() {
            return !!($scope.preview && $scope.can_preview)
        }
    }
}());
