<?php
$_db_migration_to = '01.02';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_quiz_qual_code.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz', 'qualification_code_id', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('02_add_retakes.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz', 'max_retakes', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('03_retake_allow_null.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('quiz', 'max_retakes', 'max_retakes', 'INT NULL');
DB_UPDATE_FILE
);


$migrations->Run('04_default_retakes.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// dev reset. Won't affect clients in the future as it'll run alongside initial install
$db->query('UPDATE quiz SET max_retakes = NULL WHERE max_retakes = 0');
DB_UPDATE_FILE
);


$migrations->Run('05_best_attempt.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_attempt', 'is_best', 'BOOL NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.02');
