import RenderCharts from './modules/RenderCharts';

define(['jquery', 'highcharts'], function ($, highcharts) {
    return function() {
        $(document).ready(() => {
            const chart  = new RenderCharts(highcharts);

            // select result types
            $('select[name="result"]').on('change', function() {
                if ($(this).val() === 'individual') {
                    // redirect to {d+}#/results
                    window.location.href = window.location.href.replace('/results', '#/results/individual');
                }

                if ($(this).val() === 'summary') {
                    // redirect to {d+}#/results
                    window.location.href = window.location.href.replace('#/results/individual', '/results');
                }
            })

            // plot chart
            $('.highcharts-element').map(function() {
                const id = $(this).attr('id');

                chart.draw(id, 'bar');
            })

            // change chart type
            $('.chart-select').on('change', function() {
                const type = ~~$(this).val() === 0 ? 'bar': 'pie';
                const chartId = $(this).attr('src-data');

                chart.draw(chartId, type);
            })
        })
    }
});
