define(['jquery'], function ($) {
    return function () {

        // newly added answers will be negative
        var answers = -1;
        var html = $('#option-box').clone().html();

        var selectorType = 'checkbox';
        var selector = $('#' + selectorType + '-selector').clone().html();

        // any non-whitespace character
        var validAnswerRegex = /\S/;

        /**
         * expand new answers
         */
        $('body').on('click', '.js-new-option', function (e) {
            $(this).animate({'margin-top': '45px'}, 300, 'easeOutCirc', function () {
                newAnswer($(this));
            });
            e.preventDefault();
            return false;
        });

        /**
         * expand new answers on enter key press
         */
        $(document).on('keypress', function (e) {
            if (e.keyCode === 13 && $('.js-option-text').is(':focus')) {
                $('.js-new-option').animate({'margin-top': '45px'}, 300, 'easeOutCirc', function () {
                    newAnswer($(this));
                });
                e.preventDefault();
                return false;
            }
        });

        /**
         * validate question form and submit
         */
        $('.js-question-form').submit(function (event) {
            var valid = 0;

            $('.js-question-form .js-option-text').each(function (index, answer) {
                if (validAnswerRegex.test($(answer).val())) {
                    valid++;
                }
            });

            if (valid < 2) {
                cla.showMessage(lmsg('quiz.admin.no_options'), null, true);

                event.preventDefault();

                return false;
            }
        });

        /**
         * create a new answer div and selection
         * @param $answerDiv
         */
        function newAnswer($answerDiv) {
            // decrement the answers count in to the negatives
            var index = --answers;

            // get selector and container
            var input = $(selector);
            var box = $(html).clone();

            // set new selector value
            input.val(index);

            // set new opt id value
            box.find('.js-optid')
                .val(index);

            // hide new option box and
            box.css('opacity', '0')
                .find('.js-selector')
                .html(input);

            $('.option-control').before(box);

            if ($answerDiv) {
                $answerDiv.css('margin-top', '0');
            }

            $('.js-option-text').last().focus();
            box.animate({'opacity': '1'}, 1000, 'easeOutCirc');
        }

        /**
         * clear existing answers
         */
        /*function clear() {
            $('.js-option-group').remove();
            answers = -1;
        }*/

        /**
         * loads the question form by the given question object
         * @param question
         */
        /*function loadbyobject(question) {

            // clear answers
            clear();

            // description field
            $('#js_description').htmlcode(question.description);

            // question type radios
            $('#js-qtypes input[type="radio"]').each(function () {
                if ($(this).val() == question.type) {
                    $(this).attr({checked: "checked"});
                }
            });

            // options
            for (var i in question.options) {
                if (question.options.hasOwnProperty(i)) {

                    var option = question.options[i];
                    var is_correct = option.correct ? 'checked' : false;

                    newAnswer();
                    $('.js-option-group:last input[name="correct[]"]').attr({ checked: is_correct });
                    $('.js-option-group:last .js-option-text').val(option.text);
                }
            }

            answers = -1;
        }*/

        /**
         * initialise question autocomplete
         */
        /*$('#js-autocomplete').easyAutocomplete({
         url: function (phrase) {
         this.data = { phrase: phrase };
         return api+'questions/search';
         },
         list: {
         maxNumberOfElements: 10,
         match: { enabled: true },
         onChooseEvent: function () {
         var question = $('#js-autocomplete').getSelectedItemData();
         loadbyobject(question);
         }
         },
         getValue: 'text',
         requestDelay: 500,
         theme: 'blue-light'
         });*/

    };
});
