
(function () {
    'use strict';

    angular.module('cla.poll')
        .controller('finishController', finishController);

    finishController.$inject = ['$scope', '$window', '$location', '$route', 'pollTracker', 'pollResources', 'pollRedirect'];

    /**
     *
     * @param $scope
     * @param $window
     * @param $location
     * @param $route
     * @param pollTracker
     * @param pollResources
     * @param pollRedirect
     * @constructor
     */
    function finishController($scope, $window, $location, $route, pollTracker, pollResources, pollRedirect) {
        $scope.content = null;
        $scope.results = null;
        $scope.questions = null;
        $scope.can_retake = true;
        $scope.attempt_id = null;

        $scope.localise = localise;
        $scope.retake = retake;
        $scope.answersTemplate = answersTemplate;
        $scope.hasEnded = hasEnded;
        $scope.showRetake = showRetake;

        $scope.poll_id = $window.poll_preload.poll.id;

        $scope.canonicalUrl = $window.poll_preload.canonicalUrl;

        init();

        /**
         * initialise controller, with routing
         */
        function init() {
            $scope.isIE = /msie\s|trident\/|edge\//i.test(window.navigator.userAgent);
            $scope.content = $window.poll_preload;
            $scope.question = $scope.content.poll.question[0].text;

        }

        /**
         * update the results if nothing has been set on this page.
         */
        function results() {
            // if (!pollTracker.results) {
            //     angular.element("#poll-wrap").hide();
            //     var attempt = null;
            //     if ($route.current.params.attempt) {
            //         attempt = $route.current.params.attempt;
            //     }
            //
            //     pollResources.getResults($scope.poll_id, attempt).$promise.then(function (data) {
            //         pollTracker.results = data.results;
            //         $scope.results = pollTracker.results;
            //         $scope.can_retake = data.can_retake;
            //         $scope.attempt_id = data.attempt_id;
            //
            //         angular.element("#poll-wrap").show();
            //     }, function (response) {
            //         pollRedirect.toPoll($scope.poll_id, response.data.message, true);
            //     });
            // }
            //
            // $scope.results = pollTracker.results;
            // $scope.content = $window.poll_preload.poll;
            // $scope.questions = pollTracker.questions;
            // $scope.answers = pollTracker.chosen;
            // $scope.can_retake = pollTracker.can_retake;
            // $scope.attempt_id = pollTracker.attempt_id;
            //
            // // easter egg
            // var perfect = ($scope.results && parseInt($scope.results.user_points) === parseInt($scope.results.max_points));
            //
            // if (perfect) {
            //     partyTime();
            // }
        }

        /**
         * localisation
         * @returns {string}
         */
        function localise() {
            return String.localise.apply(this, arguments);
        }

        function hasEnded() {
            if (!$scope.content.poll.end_date) {
                return false
            }

            return new Date($scope.content.poll.end_date) < new Date()
        }

        /**
         * goes back to poll intro page
         */
        function retake() {
            pollTracker.init(pollTracker.questions);
            pollTracker.update();
            pollTracker.is_retaking = true;

            $location.path('/')
        }

        /**
         * fetches the answers datatable template
         */
        function answersTemplate() {
            if ($scope.attempt_id) {
                return '/poll/attempt/' + $scope.attempt_id + '/template';
            }
        }

        function showRetake() {
            if ($scope.can_retake && !hasEnded())
                return true;

            return false;
        }
    }

}());
