/**
 * Controls the  quiz results
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
    'use strict';

    angular.module('cla.quiz')
        .controller('finishController', finishController);

    finishController.$inject = ['$scope', '$window', '$route', 'quizTracker', 'quizResources', 'quizRedirect'];

    /**
     *
     * @param $scope
     * @param $window
     * @param $route
     * @param quizTracker
     * @param quizResources
     * @param quizRedirect
     * @constructor
     */
    function finishController($scope, $window, $route, quizTracker, quizResources, quizRedirect) {
        $scope.content = null;
        $scope.results = null;
        $scope.questions = null;
        $scope.can_retake = true;
        $scope.attempt_id = null;

        $scope.localise = localise;
        $scope.retake = retake;
        $scope.answersTemplate = answersTemplate;
        $scope.getDoneUrl = getDoneUrl;

        $scope.quiz_id = $window.quiz_preload.quiz.id;

        $scope.canonicalUrl = $window.quiz_preload.canonicalUrl;

        init();

        /**
         * initialise controller, with routing
         */
        function init() {
            results();
        }

        /**
         * update the results if nothing has been set on this page.
         */
        function results() {
            if (!quizTracker.results) {
                angular.element("#quiz-wrap").hide();
                var attempt = null;
                if ($route.current.params.attempt) {
                    attempt = $route.current.params.attempt;
                }

                quizResources.getResults($scope.quiz_id, attempt).$promise.then(function (data) {
                    quizTracker.results = data.results;
                    $scope.results = quizTracker.results;
                    $scope.can_retake = data.can_retake;
                    $scope.attempt_id = data.attempt_id;

                    angular.element("#quiz-wrap").show();
                }, function (response) {
                    quizRedirect.toQuiz($scope.quiz_id, response.data.message, true);
                });
            }

            $scope.results = quizTracker.results;
            $scope.content = $window.quiz_preload.quiz;
            $scope.questions = quizTracker.questions;
            $scope.answers = quizTracker.chosen;
            $scope.can_retake = quizTracker.can_retake;
            $scope.attempt_id = quizTracker.attempt_id;

            // easter egg
            var perfect = ($scope.results && parseInt($scope.results.user_points) === parseInt($scope.results.max_points));

            if (perfect) {
                partyTime();
            }
        }

        /**
         * localisation
         * @returns {string}
         */
        function localise() {
            return String.localise.apply(this, arguments);
        }

        /**
         * goes back to quiz intro page
         */
        function retake() {
            quizTracker.init(quizTracker.questions);
            quizTracker.update();

            $window.location.href = "/quiz/" + $scope.quiz_id;
        }

        /**
         * Get correct return URL for Quiz
         *
         * @returns {string}
         */
        function getDoneUrl() {
            // Use URLSearchParams to parse query
            var params = new URLSearchParams($window.location.search);

            var courseId = parseInt(params.get('course_id'));
            var moduleId = parseInt(params.get('module_id'));

            if (!(moduleId && moduleId > 0))
                return '/quiz';

            if (!courseId || courseId <= 0)
                return '/learning/courses/modules/' + moduleId;

            return '/learning/courses/' + courseId + '/modules/' + moduleId;
        }

        /**
         * fetches the answers datatable template
         */
        function answersTemplate() {
            if ($scope.attempt_id) {
                return '/quiz/attempt/' + $scope.attempt_id + '/template';
            }
        }

        /**
         * swoooosh! confetti.
         */
        function partyTime() {
            $window.confetti.start();
        }
    }

}());
