/**
 * Controls the  quiz results
 *
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
    'use strict';

    angular.module('cla.quiz')
        .controller('reviewController', reviewController);

    reviewController.$inject = ['$scope', '$window', '$location', 'quizTracker', 'quizActions'];

    /**
     *
     * @param $scope
     * @param $route
     * @param quizTracker
     * @param quizActions
     * @constructor
     */
    function reviewController($scope, $window, $location, quizTracker, quizActions) {

        $scope.content = null;
        $scope.finish = finish;
        $scope.back = back;
        $scope.getTotalQuestions = getTotalQuestions;
        $scope.getCompleteQuestions = getCompleteQuestions;
        $scope.getIncompleteQuestions = getIncompleteQuestions;

        $scope.reviewAll = reviewAll;
        $scope.reviewQuestions = reviewQuestions;

        $scope.quiz_id = $window.quiz_preload.quiz.id;
        $scope.preview = $window.quiz_preload.preview;

        $scope.canonicalUrl = $window.quiz_preload.canonicalUrl;

        init();

        /**
         * initialise controller, with routing
         */
        function init() {

            if (!quizTracker.questions.length) {
                angular.element("#quiz-wrap").hide();
                quizActions.start($scope.quiz_id, function () {
                    angular.element("#quiz-wrap").show();
                });
            }

            $scope.$on('quiz.finished', $scope.finish);
            review();
        }

        /**
         * load review content
         */
        function review() {
            $scope.content = $window.quiz_preload.quiz;
        }

        /**
         * finish the quiz
         */
        function finish() {
            quizActions.finish($scope.quiz_id, function () {
                if (!$scope.preview) {
                    $location.path('/finish');
                } else {
                    $window.location.href = '/quiz/' + $scope.quiz_id + '/review';
                }
            });
        }

        /**
         * back to quiz
         */
        function back() {
            quizTracker.resetTracker();
            $location.path('/continue');
        }

        /**
         * the total number of questions
         */
        function getTotalQuestions() {
            return $window.quiz_preload.question_count;
        }

        /**
         * the number of questions a user has answered
         */
        function getCompleteQuestions() {
            return quizTracker.getChosenCount();
        }

        /**
         * the number of questions the user has yet to answer
         */
        function getIncompleteQuestions() {
            var total = $window.quiz_preload.question_count;
            var completed = $scope.getCompleteQuestions();
            return total - completed;
        }

        /**
         * review all questions
         */
        function reviewAll() {
            quizTracker.resetTracker();
            $location.path('/continue');
        }

        /**
         * review complete or incomplete questions
         * @param as_complete
         */
        function reviewQuestions(as_complete) {
            var questions = as_complete ? quizTracker.getComplete() : quizTracker.getIncomplete();
            if (questions.length > 0) {
                // update tracker and set question to the first in the list
                quizTracker.setTracker(questions);
                quizTracker.question = quizTracker.tracker[0];
                quizTracker.update();

                $location.path('/continue');
            }
        }
    }
}());
