/**
 * Navigation bar within a survey
 */
'use strict';

(function () {
    angular.module('cla.survey').directive('claSurveyNavBar', navBar);

    navBar.$inject = ['$rootScope','surveyTracker', 'surveyActions', '$window'];

    /**
     * @param surveyTracker
     * @param surveyActions
     * @constructor
     */
    function navBar($rootScope, surveyTracker, surveyActions, $window) {
        return {
            bindToController: true,
            controller: controller,
            controllerAs: 'navbar',
            link: link,
            replace: true,
            restrict: 'E',
            scope: {
                surveyId: '@'
            },
            templateUrl: '/intranet/quiz/html/templates/survey/navbar.html'
        };

        function controller() {
            let $ctrl = this;

            this.sections = [];
            this.instantFeedback = false;

            /**
             * go to a given question
             * @param $index
             */
            this.navigate = function($index) {
                surveyActions.next($ctrl.surveyId);
                surveyTracker.goto(surveyTracker.tracker[$index]);

                if ($index === surveyTracker.tracker.length - 1) {
                    return $rootScope.isLastSection = true
                }

                $rootScope.isLastSection = false;

                $window.scrollTo(0, 0);
            }

            /**
             * is the currently selected question active?
             * @param $index
             * @returns {boolean}
             */
            this.isActive = function($index) {
                return surveyTracker.question == $index;
            }

            /**
             * determines if a question is disabled (not in the tracker list)
             * @param $index
             * @returns {boolean}
             */
            this.isDisabled = function ($index) {
                for (let i = 0; i < surveyTracker.tracker.length; i++) {
                    if (surveyTracker.tracker[i] == $index)
                        return false;
                }

                return true;
            }

            init();

            function init() {
                $ctrl.sections = surveyTracker.sections;
            }

            this.isSectionError = function(index) {
                if (!surveyTracker.showFormErrors)
                    return false;

                return !surveyTracker.isSectionAnswered($ctrl.sections[index].id);
            }
        }

        function link(scope) {
            let width, li, offset;

            // watch the track position changing so we know to update the navbar offset
            scope.$watch(function () {
                return surveyTracker.trackpos;
            }, function (value) {
                if (!width) {
                    // only calculate this once when first watch loads
                    li = $('.slide-nav .slide-nav__question--active');
                    width =  li.children('button').outerWidth();
                    offset = width;
                }

                let pos = (offset * value) + offset; // add offset each time to account for "intro" button
                $('.slider-quiz-nav').animate({scrollLeft: pos}, 500);
            });
        }
    }

    requirejs(['domReady', 'jquery'], function (domReady, $) {
        domReady(function () {
            $(window).on("resize", function () {
                let win = $(this); //this = window
                if (win.width() >= 980) {
                    $('.slider-quiz-nav').kinetic('attach');
                } else {
                    $('.slider-quiz-nav').kinetic('detach');
                }
            }).resize();

            // on scroll, check position and add or remove the necessary "end" class
            $('body').on('.slider-quiz-nav', 'scroll', function () {
                if ($(this).scrollLeft() + $(this).innerWidth() >= $(this)[0].scrollWidth - 50) {
                    $(".slider-nav-wrap").addClass("end");
                } else {
                    $(".slider-nav-wrap").removeClass("end");
                }
            });
        });
    });

}(window));
