/**
 * Start controller test cases
 * @author Simon Willan <simon.willan@claromentis.com>
 */
(function () {
    'use strict';

    describe('Start controller', function () {

        var $httpBackend, $scope, quizActions, quizTracker, $controller, response;

        // load cla.quiz
        beforeEach(angular.mock.module('cla.quiz'));

        // set out injected resources factory
        beforeEach(function () {

            response = {
                "attempt": {id: 1},
                "answers": {1: {}},
                "questions": [{}, {}]
            };

            angular.mock.inject(function ($injector) {

                $httpBackend = $injector.get('$httpBackend');
                $scope = $injector.get('$rootScope');
                $controller = $injector.get('$controller');

                quizTracker = $injector.get('quizTracker');
                quizActions = $injector.get('quizActions');

                $controller('startController', {
                    $scope: $scope,
                    $window: {quiz_preload: {quiz: {id: 1}}},
                    quizTracker: quizTracker,
                    quizActions: quizActions
                });

                $httpBackend.whenPOST('/api/quiz/v1/1/start')
                    .respond(response);
            });

        });

        afterEach(function () {
            $httpBackend.verifyNoOutstandingRequest();
            $httpBackend.verifyNoOutstandingExpectation();
        });

        // controller initialisation tests
        describe('.init()', function () {

            // test to make sure the promise is made
            it('should make sure the resulting questions array from the $promise is set on the quizTracker', function () {

                // flush fake server request, resulting in call to $promise.then();
                $httpBackend.flush();

                // check response is being fed to quiz tracker
                expect(quizTracker.questions).toEqual(response.questions);
            });

            // test
            it('should set a content property so that the view can expose the current question', function () {

                // flush fake server request.
                $httpBackend.flush();

                // check content is not null and is set to the current question as defined by tracker.
                expect($scope.content).not.toBeNull();
                expect($scope.content).toEqual(quizTracker.current);
            });
        });

        // black boxed aux functions
        describe('auxilliary functions', function () {

            it('should have a way to fetch the option number as a letter (e.g. A, B or C)', function () {

                // flush request from controller initialisation.
                $httpBackend.flush();

                spyOn($scope, 'getOptionLetter').and.callThrough();

                var A = $scope.getOptionLetter(0);
                var B = $scope.getOptionLetter(1);

                expect($scope.getOptionLetter).toHaveBeenCalledWith(jasmine.any(Number));
                expect(A).toBe('A');
                expect(B).toBe('B');
            });

        });

    });

}());
