<?php
namespace Claromentis\Quiz\Search\Indexing;

$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"] ?: array()) + array("_99cee2d22" . "72a8550f4b" . "21e3cb57ff" . "f7d" => base64_decode("ZW5hYmxlZA=" . "="), "_646df53034" . "0668323d9a8" . "e6c9204fe75" => base64_decode("aW1hZ2Vfc3J" . "j"), "_33de78378f32407b852c241" . "ec52f9a35" => base64_decode("aHJlZg=" . "="), "_5296e137570b02bad64c77" . "2bd9d734de" => base64_decode("VW5rbm93biBzcGVjaWFsIGFjdGlvbiBmb3IgUXV" . "peiBpbmRleGluZzog"), "_f73dab606630b388645c4f7d3fbb1" . "3bb" => base64_decode("YXJyYX" . "lfbWVy" . "Z2U="), "_aa7e860da1acd4e767e0df9d7" . "d407380" => base64_decode("ZGF0ZV9jcmVhd" . "GVk"), "_d43b1a885195a4b6ccc7d38ba3fcb1" . "f9" => base64_decode("Z2x5cGhp" . "Y29u"), "_d0acf63c20abded6f7458ea8e" . "7009e96" => base64_decode("SW5zdHJ1Y3Rpb24gb2JqZWN" . "0IElEIG5vdCBmb3VuZCBmb3" . "IgUXVpeg=="), "_4d707fab93bebb00b" . "be69e8159697c90" => base64_decode(""), "_b0eaaa9541f479b4891f61611174" . "37b9" => base64_decode("cXVldWVfZnVsb" . "F9yZWluZGV4"), "_66824e0309bb" . "76c78bd2bbd5f" . "da8d3d8" => base64_decode("c3" . "Ry" . "aW" . "5n"), "permission" . "s" => base64_decode("cGVybWlzc" . "2lvbnM="), "_b15aac3aa29c10ea6d1228f58cb9a7" . "e8" => base64_decode("b2J" . "qZW" . "N0"), "_6ebc0afe64bb119c" . "e3df66d2745d8c38" => base64_decode("IGlzIG5vdCBMaXZlLCBzbyB" . "pdCB3aWxsIG5vdCBiZSBpbm" . "RleGVk"), "_8e7b0b07b8" . "da9d5cbd9a4" . "1129b629400" => base64_decode("ZGF0ZV9kZXR" . "lY3Rpb24="), "_8ac93b484d" . "7470c59e327" . "620646e2d1e" => base64_decode("X3NvdXJj" . "ZQ=="), "_fa96cdf58bff3b0695f" . "b2bc0803d7b12" => base64_decode("IGRvZXMgbm90IGV4aX" . "N0"), "_dadf790ba" . "f241afac94" . "2824c1e6e3" . "7c4" => base64_decode("dHlw" . "ZQ=="), "_809a58dc730" . "11173c031a53" . "c0b40ef0e" => base64_decode("cHJvcGVydGll" . "cw=="), "_7aefd482de7885f4293c2926df" . "28c235" => base64_decode("anNvbl9lbmNv" . "ZGU="), "_df49a98e61" . "30f798876ec" . "bf6bddc70d9" => base64_decode("UXVpe" . "iB3aX" . "RoIEl" . "EIA=="), "_d7bc4f883" . "b1e96e6f53" . "4b781deddd" . "d6b" => base64_decode("Z2x5cGhpY29ucyBnbHlwaGljb25z" . "LXF1ZXN0aW9uLXNpZ24="), "_31767d7ad58e706dbf47b" . "7a51a0fe6c4" => base64_decode("Y291b" . "nQ="), "_feb9037589181" . "bc30fa0f1cf78b" . "9f056" => base64_decode("dGl0bGU" . "="), "_8e7f4b5c8440c0a24" . "fb1b632eee28538" => base64_decode("YWN0aW9" . "u"), "_e03f42611" . "10db60749f" . "3b7cd2c237" . "77f" => base64_decode("UXVpei" . "A="), "_d34599da" . "eb8cca374" . "d3adb38b2" . "45839c" => base64_decode("Y29udGVud" . "HM="), "_2b2fdacf7b152cff4f3819c30fd58b" . "1a" => base64_decode("L3F1aXo" . "v"), "_07954ed0fb" . "98865511b46" . "87244275502" => base64_decode("cXVp" . "ei9j" . "b3Zl" . "cnM="));
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\CDN\CDNInterface;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Quiz\Model\Quiz;
use Claromentis\Quiz\Permissions\QuizAdminPermissions;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository\QuizRepository;
use Claromentis\Search\FieldType\TypeContents;
use Claromentis\Search\FieldType\TypeDate;
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Exception\IndexingException;
use Claromentis\Search\Indexing\Exception\NothingToIndexException;
use Claromentis\Search\Indexing\Exception\ObjectNotFoundException;
use Claromentis\Search\Indexing\Exception\UnsupportedOperationException;
use Claromentis\Search\Indexing\IndexingInstruction;
use Claromentis\Search\Indexing\IndexingItemInterface;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\Permissions as SearchPermissions;
use ClaText;
use Permissions;




class QuizIndexing implements IndexingItemInterface
{
    const TYPE_NAME = 'quiz';
    
    
    protected $cdn;
    
    
    protected $cla_text;
    
    
    protected $quiz_repo;
    
    
    protected $acl_repo;
    public function __construct(CDNInterface $cdn, \Claromentis\Core\TextUtil\ClaText $cla_text, QuizRepository $quiz_repo, AclRepository $_3436ad73cf80729d5a2e43d861c31e8b)
    {
        $this->cdn = $cdn;
        $this->cla_text = $cla_text;
        $this->quiz_repo = $quiz_repo;
        $this->acl_repo = $_3436ad73cf80729d5a2e43d861c31e8b;
    }
    
    
    
    
    
    
    public function InitMapping(ClientInterface $_87419315d6aaaec7dd2250b14245566e)
    {
        $_87419315d6aaaec7dd2250b14245566e->AddMapping(self::TYPE_NAME, [$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_8ac93b484d7470c59e32" . "7620646e2d1e"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_99cee2d2272a8550f4b21" . "e3cb57fff7d"] => true], $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8e7b0b07b8da9d5cbd9a41129b6294" . "00"] => true, $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_809a58dc7301117" . "3c031a53c0b40ef0" . "e"] => [$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_feb9037589181bc30fa0" . "f1cf78b9f056"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_dadf790baf241afac" . "942824c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_66824e0309bb76c78bd2bbd5fda" . "8d3d8"]], $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_33de78378f32407b852c241ec" . "52f9a35"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_dadf790baf241afac942824c" . "1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_66824e0309bb76c78" . "bd2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_99cee2d22" . "72a8550f4b" . "21e3cb57ff" . "f7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_646df530" . "340668323" . "d9a8e6c92" . "04fe75"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_dadf790baf241afac94" . "2824c1e6e37c4"] => $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_66824e0309bb76c78bd2bbd5fda8d" . "3d8"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_99cee2d2272a8550f4b21e3cb57fff" . "7d"] => false], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_d43b1a885195a4b6ccc7d38ba3" . "fcb1f9"] => [$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_dadf790ba" . "f241afac94" . "2824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_66824e0309bb76c78b" . "d2bbd5fda8d3d8"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_99cee2d2272a8550f4b21e3cb57f" . "ff7d"] => false], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_d34599daeb8cca374d" . "3adb38b245839c"] => TypeContents::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_aa7e860d" . "a1acd4e76" . "7e0df9d7d" . "407380"] => TypeDate::GetPropertiesMapping(), $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["permis" . "sions"] => array($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_dadf790baf241afac942824c1e6e3" . "7c4"] => $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_b15aac3aa29c10ea6d1228f58c" . "b9a7e8"], $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_809a58dc73011173" . "c031a53c0b40ef0e"] => SearchPermissions::GetPropertiesMapping())]]);
    }
    
    
    
    
    
    
    
    public function Index(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_d0acf63c20abded6f" . "7458ea8e7009e96"]);
        }
        
        
        
        
        $_8652ba33e6ffeba02459fa9cbb320851 = $this->quiz_repo;
        try {
            
            
            
            
            $quiz = $_8652ba33e6ffeba02459fa9cbb320851->Get($_8c5f17e2e918145535955f8a633b6c7b->object_id);
        } catch (NotFoundException $_c35473364fa7a050299058f332ec29c1) {
            throw new ObjectNotFoundException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_df49a98e6130f7988" . "76ecbf6bddc70d9"] . $_8c5f17e2e918145535955f8a633b6c7b->object_id . $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_fa96cdf" . "58bff3b0" . "695fb2bc" . "0803d7b1" . "2"]);
        }
        
        
        if (!$quiz->IsLive()) {
            throw new NothingToIndexException($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_e03f4261110db607" . "49f3b7cd2c23777f"] . $quiz->id . $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_6ebc0afe64bb119c" . "e3df66d2745d8c38"]);
        }
        
        
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = $this->GetIndexData($quiz);
        $_87419315d6aaaec7dd2250b14245566e->Index(self::TYPE_NAME, $quiz->id, $_a6fb9cc38e2b15d5b2d8171e60aa3cbe);
    }
    
    
    
    
    
    
    protected function GetIndexData(Quiz $quiz)
    {
        $_6137f6b1054c046b6733dcd025f03c02 = $quiz->GetImage($this->cdn, $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_07954ed0fb988" . "65511b46872442" . "75502"]);
        $_a6fb9cc38e2b15d5b2d8171e60aa3cbe = [$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_feb9037589181bc30fa0f" . "1cf78b9f056"] => $quiz->title, $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_33de7837" . "8f32407b8" . "52c241ec5" . "2f9a35"] => $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_2b2fdacf7b152" . "cff4f3819c30fd" . "58b1a"] . $quiz->id, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_646df53" . "03406683" . "23d9a8e6" . "c9204fe7" . "5"] => $_6137f6b1054c046b6733dcd025f03c02, $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_d34599daeb8cca374d3adb3" . "8b245839c"] => $this->cla_text->BBCode2Plain((string) $quiz->description), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_aa7e860da1acd4e767e0df9d7d" . "407380"] => TypeDate::Format($quiz->created_date), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["permi" . "ssion" . "s"] => $this->GetPermissionsIndexData($quiz)];
        if ($_6137f6b1054c046b6733dcd025f03c02 === $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_4d707fab93bebb00b" . "be69e8159697c90"]) {
            $_a6fb9cc38e2b15d5b2d8171e60aa3cbe[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d43b1a885195a4" . "b6ccc7d38ba3fcb" . "1f9"]] = $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_d7bc4f883b1e96e6f534b7" . "81dedddd6b"];
        }
        return $_a6fb9cc38e2b15d5b2d8171e60aa3cbe;
    }
    
    
    
    
    
    
    
    protected function GetPermissionsIndexData(Quiz $quiz)
    {
        
        
        $permissions = new Permissions(QuizPermissions::CLASS_QUIZ, $quiz->id);
        $permissions->Load();
        $_665240f1a489ba897ccc8ace510a47cb = new Permissions(QuizAdminPermissions::CLASS_QUIZ_ADMIN, 1);
        $_665240f1a489ba897ccc8ace510a47cb->Load();
        
        
        $_c9dab5b1c7628cf9721eea495ec5d40b = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_f73dab60663" . "0b388645c4f7" . "d3fbb13bb"]($_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_MANAGE_ALL), $_665240f1a489ba897ccc8ace510a47cb->GetAllOwnersList(QuizAdminPermissions::PERM_VIEW_ALL_STATISTICS));
        
        
        foreach ($_c9dab5b1c7628cf9721eea495ec5d40b as $_c4d674abe9291be143b224c411958fcf) {
            list($_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d) = $_c4d674abe9291be143b224c411958fcf;
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, $_fab148434571859ce581a09251188f00, $_28685591a1d64debd044e3074d01b84d);
        }
        
        
        $_f053e79538903e098fb90b42736274df = QuizAdminPermissions::CanManageOwn($this->acl_repo, SecurityContext::CreateForUser($quiz->created_by));
        if ($_f053e79538903e098fb90b42736274df) {
            $permissions->Add(QuizPermissions::PERM_ATTEMPT, PermOClass::INDIVIDUAL, $quiz->created_by);
        }
        
        
        $_5572df110aae46854e281078ba4712b2 = new SearchPermissions();
        return $_5572df110aae46854e281078ba4712b2->GetIndexDataSimple($permissions);
    }
    
    
    
    
    
    
    public function Delete(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        
        
        if (!$_8c5f17e2e918145535955f8a633b6c7b->object_id) {
            return;
        }
        
        
        $_87419315d6aaaec7dd2250b14245566e->Delete(self::TYPE_NAME, $_8c5f17e2e918145535955f8a633b6c7b->object_id);
    }
    
    
    
    
    
    
    protected function GetAllQuizIds()
    {
        return $this->quiz_repo->ListQuizIds(false);
    }
    
    
    
    
    
    
    public function QueueFullIndex()
    {
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Index(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_31767d7ad58e" . "706dbf47b7a51" . "a0fe6c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    public function QueueFullReindex($_4433a5922f5df0ebd8436fbb431e146c)
    {
        if (!$_4433a5922f5df0ebd8436fbb431e146c) {
            return $this->QueueFullIndex();
        }
        $_3e1ef20d972361db64536e4c72bb1649 = $this->GetAllQuizIds();
        foreach ($_3e1ef20d972361db64536e4c72bb1649 as $quiz_id) {
            IndexingQueue::Reindex(self::TYPE_NAME, $quiz_id);
        }
        return $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_31767d7ad58e706dbf47b7a51a0fe6" . "c4"]($_3e1ef20d972361db64536e4c72bb1649);
    }
    
    
    
    
    
    
    
    
    public function Special(ClientInterface $_87419315d6aaaec7dd2250b14245566e, IndexingInstruction $_8c5f17e2e918145535955f8a633b6c7b)
    {
        $_8e7f4b5c8440c0a24fb1b632eee28538 = $_8c5f17e2e918145535955f8a633b6c7b->extra[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_8e7f4b5c8440c0a24fb1b6" . "32eee28538"]];
        if ($_8e7f4b5c8440c0a24fb1b632eee28538 !== $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_b0eaaa9541f479b" . "4891f6161117437b" . "9"]) {
            throw new UnsupportedOperationException($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_5296e137570b0" . "2bad64c772bd9d" . "734de"] . $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_7aefd482de7885f4293c2926df2" . "8c235"]($_8c5f17e2e918145535955f8a633b6c7b->extra));
        }
        $this->QueueFullReindex(true);
    }
}