<?php
$_db_migration_to = '11.01'; // 2.3.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_indexes.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Indexes for:
// Table: quiz_anonymous
$db->CreateIndex('quiz_anonymous', 'idx_object_type_id', 'object_type', 'object_id');

// Table: quiz_answer
$db->CreateIndex('quiz_answer', 'idx_attempt_id', 'attempt_id');
$db->CreateIndex('quiz_answer', 'idx_question_id', 'question_id');

// Table: quiz_attempt
$db->CreateIndex('quiz_attempt', 'idx_object_type_id', 'object_type', 'object_id');
/* sort by attempt */
$db->CreateIndex('quiz_attempt', 'idx_attempt', 'attempt');

// Table: quiz_section
$db->CreateIndex('quiz_section', 'idx_survey_id', 'survey_id');

// Table: quiz_answer_choice
$db->CreateIndex('quiz_answer_choice', 'idx_question_id', 'question_id');
$db->CreateIndex('quiz_answer_choice', 'idx_option_id', 'option_id');

// Table: quiz_poll
$db->CreateIndex('quiz_poll', 'idx_status', 'status');
$db->CreateIndex('quiz_poll', 'idx_created_date', 'created_date');
/* poll notification indexes */
$db->CreateIndex('quiz_poll', 'idx_start_date', 'start_date');
$db->CreateIndex('quiz_poll', 'idx_end_date', 'end_date', 'show_results', 'has_notification', 'end_notification_sent');

// Table: quiz_survey
$db->CreateIndex('quiz_survey', 'idx_status', 'status');
$db->CreateIndex('quiz_survey', 'idx_created_date', 'created_date');
/* survey notification indexes */
$db->CreateIndex('quiz_survey', 'idx_start_date', 'start_date', 'notification_sent');
$db->CreateIndex('quiz_survey', 'idx_end_date', 'end_date', 'show_results', 'has_notification', 'end_notification_sent');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('11.01');
