<?php
namespace Claromentis\Quiz\Facade;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] ?: array()) + array("_69be62fd7fe74eeb696430be" . "f3e07069" => base64_decode("c2hvd19oZWxw" . "X3RleHQ="), "_b4af1f7aa1ccde1a44" . "9e9d8afe15b753" => base64_decode("cmVzdWx0c" . "w=="), "_bc29a32ad8f2fef03c86624cd" . "1f97174" => base64_decode("cXVpei5lcnJvci5hdHRlbX" . "B0X2NhbmNlbGxlZA=="), "_824bf7ef94e1d4ffd60109e" . "ae15a03de" => base64_decode("c2hvd19yZXN1" . "bHRz"), "_2424e587f1d2260ed1140" . "b0c3a04957c" => base64_decode("cXVpei5lcnJvci5ub19hdHRlbXB0X3Blc" . "m1z"), "_2efbc177e1ad89b385c991e1a24" . "c3d4d" => base64_decode("cXVpei5lcnJvci5ub19x" . "dWVzdGlvbnM="), "_b9c4587b" . "9af707e3b" . "9b62f38b8" . "bd07d0" => base64_decode("SD" . "pp" . "On" . "M="), "_9624bbc454278afb5470b43" . "ba4e309aa" => base64_decode("cXVpel9" . "wZXJjZW" . "50"), "_4a397d01c1669f4f" . "c3143b3ede57982a" => base64_decode("bWF4X3B" . "vaW50cw" . "=="), "_5846ddea7ff6d30bd0e7b4" . "a81710776e" => base64_decode("YXJyYXlfc2hp" . "ZnQ="), "_62d701c3c53404f06" . "345eb35720a47b4" => base64_decode("aXNfbnVtZXJpY" . "w=="), "_7864d2966f47ed1bdb4045" . "7d0c0fc6cd" => base64_decode("Z21" . "kYX" . "Rl"), "_670ae7cfad454a5d2068" . "a664fe492b8b" => base64_decode("cGFzc" . "2Vk"), "_1f61c253d44e3b7dfa35ebe010c" . "3f61d" => base64_decode("cXVpel9w" . "b2ludHM="), "_0c7db5a15ed94cc1" . "be4b039915fb0814" => base64_decode("Y2FuX3Jld" . "GFrZQ=="), "_b1d9743" . "b68fd81c" . "c4d60987" . "cbf4b4f5" . "7" => base64_decode("YW5zd2Vy" . "cw=="), "_0c5123aa744f69b" . "bc0e8b3ea2f6e847" . "d" => base64_decode("bG1" . "zZw" . "=="), "_48b11ff6a9c9" . "a962ed664af78" . "1989076" => base64_decode("ZGF0ZV9jb21wbG" . "V0ZWQ="), "atte" . "mpt_" . "id" => base64_decode("YXR0ZW1wdF9pZA" . "=="), "_8bafa036940b9541eaa68bfae2d4" . "57ab" => base64_decode("dGltZV90Y" . "Wtlbg=="), "_381f559a72e38" . "d182696693daae" . "c5aaf" => base64_decode("YXJyYX" . "lfcmVk" . "dWNl"), "_5413cd7" . "4395149d" . "2eb1ed57" . "dca5f7f6" . "d" => base64_decode("dXNlcl9wb2ludHM" . "="));
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\People\Exception\PermissionException;
use Claromentis\Quiz\Model;
use Claromentis\Quiz\Permissions\QuizPermissions;
use Claromentis\Quiz\Repository;
use Exception;
use RestExForbidden;
use RestExNotFound;





class QuizFacade
{
    
    
    
    
    protected $attempt_repo;
    
    
    
    
    private $quiz_repo;
    
    
    
    
    private $question_repo;
    
    
    
    
    private $junction_repo;
    
    
    
    
    private $option_repo;
    
    
    
    
    
    
    
    
    
    
    public function __construct(Repository\QuizRepository $quiz_repo, Repository\QuestionRepository $question_repo, Repository\QuizQuestionRepository $junction_repo, Repository\OptionRepository $option_repo, Repository\AttemptRepository $attempt_repo)
    {
        $this->quiz_repo = $quiz_repo;
        $this->question_repo = $question_repo;
        $this->junction_repo = $junction_repo;
        $this->option_repo = $option_repo;
        $this->attempt_repo = $attempt_repo;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetQuestionsForQuiz($quiz, $question_id = 0, $_a533ab42257ef7a3ab56ae81095ba76a = false, $_f11369824f533e8206f9ccc0c9aab3a0 = 0, $_1f50e30be8c2fefa6881834e71d504a2 = 0)
    {
        $quiz_id = $quiz;
        
        
        if ($quiz instanceof Model\Quiz) {
            $quiz_id = $quiz->id;
        }
        
        
        $_c3260c2f0284e4cb0a840360d54cfc77 = $this->junction_repo->ListJunctions($quiz_id, $question_id);
        
        
        $_ccac80360ec3a22ae939584a5b406d92 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_381f559a7" . "2e38d18269" . "6693daaec5" . "aaf"]($_c3260c2f0284e4cb0a840360d54cfc77, function ($_ea3aa8b636de2853263bc04cc6356846, $_59cdb5ce92fcf760d09d3c6ed5b03aaa) {
            $_ea3aa8b636de2853263bc04cc6356846[] = (int) $_59cdb5ce92fcf760d09d3c6ed5b03aaa->question_id;
            return $_ea3aa8b636de2853263bc04cc6356846;
        }, []);
        
        
        $questions = array();
        if ($_ccac80360ec3a22ae939584a5b406d92) {
            $questions = $this->question_repo->GetQuizQuestions($quiz_id, $_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2);
        }
        
        
        if (!$_a533ab42257ef7a3ab56ae81095ba76a) {
            return $questions;
        }
        
        
        $this->option_repo->LoadQuestionOptions($questions);
        return $questions;
    }
    
    
    
    
    
    
    
    
    public function GetOptionsForQuestion($question, $option_id = 0)
    {
        return $this->option_repo->GetOptionsForQuestion($question, $option_id);
    }
    
    
    
    
    
    
    
    public function GetEntireQuiz($quiz_id)
    {
        if (!$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_62d701c3c53404f06" . "345eb35720a47b4"]($quiz_id)) {
            return null;
        }
        
        
        $quiz = $this->quiz_repo->Get($quiz_id);
        
        
        $questions = $this->GetQuestionsForQuiz($quiz->id);
        
        
        $this->option_repo->LoadQuestionOptions($questions);
        
        
        $quiz->SetQuestions($questions);
        return $quiz;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function GetQuizWithQuestion($quiz_id, $question_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        $question = $this->question_repo->Get($question_id);
        $question->SetOptions($this->option_repo->GetOptionsForQuestion($question_id));
        return array($quiz, $question);
    }
    
    
    
    
    
    
    
    public function GetQuizWithQuestionsCount($quiz_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        $quiz->SetQuestionsCount($this->GetQuestionsCount($quiz));
        return $quiz;
    }
    
    
    
    
    
    
    
    public function GetQuestionsCount($quiz)
    {
        return $this->question_repo->GetQuizQuestionsCount($quiz);
    }
    
    
    
    
    
    
    
    public function GetQuizPassMark($quiz_id)
    {
        $quiz = $this->GetEntireQuiz($quiz_id);
        return $quiz->GetPassPoints();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function DeleteQuiz($quiz_id)
    {
        $quiz = $this->quiz_repo->Get($quiz_id);
        
        
        
        $_c3260c2f0284e4cb0a840360d54cfc77 = $this->junction_repo->ListJunctions($quiz->id);
        
        
        $this->quiz_repo->Delete($quiz);
        
        
        foreach ($_c3260c2f0284e4cb0a840360d54cfc77 as $_c802a23eaf40ed8ad9096c3f27fe3200) {
            $this->junction_repo->Delete($_c802a23eaf40ed8ad9096c3f27fe3200);
        }
    }
    
    
    
    
    
    
    
    
    public function DeleteQuestion($quiz_id, $question_id)
    {
        
        
        $_c802a23eaf40ed8ad9096c3f27fe3200 = $this->junction_repo->ListJunctions($quiz_id, $question_id);
        if ($_c802a23eaf40ed8ad9096c3f27fe3200) {
            $_c802a23eaf40ed8ad9096c3f27fe3200 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_5846ddea" . "7ff6d30bd" . "0e7b4a817" . "10776e"]($_c802a23eaf40ed8ad9096c3f27fe3200);
            
            
            $this->junction_repo->Delete($_c802a23eaf40ed8ad9096c3f27fe3200);
        }
    }
    
    
    
    
    
    
    
    
    public function VerifyAttempt($acl, $context, $quiz_id)
    {
        $quiz = $this->GetEntireQuiz($quiz_id);
        
        
        
        if (!$quiz->HasQuestionsCount()) {
            throw new PermissionException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_0c5123aa744f69bbc0e8" . "b3ea2f6e847d"]($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_2efbc177e1ad89b385c991e1a24c3d4" . "d"]));
        }
        
        
        
        
        if ($quiz->IsDraft()) {
            throw new PermissionException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_0c5123aa744f69bbc" . "0e8b3ea2f6e847d"]($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_bc29a32ad8f2fef03c86624cd1f971" . "74"]));
        }
        
        
        if (!QuizPermissions::CanAttempt($acl, $context, $quiz, $this->attempt_repo)) {
            throw new PermissionException($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_0c5123aa744f69bbc0" . "e8b3ea2f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_2424e58" . "7f1d2260" . "ed1140b0" . "c3a04957" . "c"]));
        }
        
        
        return $quiz;
    }
    
    
    
    
    
    
    
    
    public function GetResults(Model\Attempt $_7adc269a13af5c45b5a1caf4ec75a795, $_b1d9743b68fd81cc4d60987cbf4b4f57, $context)
    {
        $object_id = $_7adc269a13af5c45b5a1caf4ec75a795->GetObjectId();
        $quiz = $this->GetEntireQuiz($object_id);
        $_0334d5cb3805f030a3472f168811ab71 = 0;
        $_ebcdbaf89b6fd6aaf65fb108576f9cbc = false;
        if ($_7adc269a13af5c45b5a1caf4ec75a795) {
            $_ebcdbaf89b6fd6aaf65fb108576f9cbc = (bool) $_7adc269a13af5c45b5a1caf4ec75a795->has_passed;
            $_0334d5cb3805f030a3472f168811ab71 = $_7adc269a13af5c45b5a1caf4ec75a795->GetScore();
        }
        $_2d06e7ff8ab3c552256f153de1fdedd2 = new \Date($_7adc269a13af5c45b5a1caf4ec75a795->completed_date);
        $_8bafa036940b9541eaa68bfae2d457ab = $_7adc269a13af5c45b5a1caf4ec75a795->GetPropertyCollection()->GetValue($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_8bafa036940b9541eaa6" . "8bfae2d457ab"]);
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_b4af1f7aa1ccde1a449e9d" . "8afe15b753"]] = array($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_670ae7cfad454a5d20" . "68a664fe492b8b"] => $_ebcdbaf89b6fd6aaf65fb108576f9cbc, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_5413cd74395" . "149d2eb1ed57" . "dca5f7f6d"] => $_0334d5cb3805f030a3472f168811ab71, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_1f61c253d44e3b7dfa3" . "5ebe010c3f61d"] => $quiz->GetPassPoints(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4a397d01c1669f4fc" . "3143b3ede57982a"] => $quiz->GetTotalPoints(), $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_9624bbc454278afb5470b43ba4e" . "309aa"] => $quiz->pass_percent, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8bafa036940b9541eaa68b" . "fae2d457ab"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_7864d2966f47ed1" . "bdb40457d0c0fc6c" . "d"]($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_b9c4587b9af707e3b9b62f3" . "8b8bd07d0"], $_8bafa036940b9541eaa68bfae2d457ab / 1000), $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_48b11ff6a9c9a962ed664a" . "f781989076"] => $_2d06e7ff8ab3c552256f153de1fdedd2->getDate(DATE_FORMAT_CLA_LONG_DATE), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_69be62fd7fe74eeb696430be" . "f3e07069"] => (int) $quiz->show_help_text, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_824bf7ef94" . "e1d4ffd6010" . "9eae15a03de"] => (int) $quiz->show_results);
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["attempt_" . "id"]] = (int) $_7adc269a13af5c45b5a1caf4ec75a795->id;
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_b1d9743b68fd81cc4d6098" . "7cbf4b4f57"]] = $_b1d9743b68fd81cc4d60987cbf4b4f57;
        $_ed5f03d686c37933b5943f295c6b4a43[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_0c7db5a15ed94c" . "c1be4b039915fb0" . "814"]] = QuizPermissions::CanReattempt($this->attempt_repo, $context, $quiz);
        return $_ed5f03d686c37933b5943f295c6b4a43;
    }
}