<?php
$_db_migration_to = '08.01'; // 2.0.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_quiz_survey_polls_tables.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// quiz
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'start_date' => "INT_DATE NOT_NULL DEFAULT 0",
	'end_date' => "INT_DATE NOT_NULL DEFAULT 0",
	'anonymous'	=>	"BOOL NOT_NULL DEFAULT 0",
	'multiple'	=>	"BOOL NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'copy_email'	=>	"BOOL NOT_NULL DEFAULT 0",
	'show_results'	=>	"BOOL NOT_NULL DEFAULT 0",
	'completion_msg' => "VARCHAR_MAX NULL"
);

$db->CreateTable('quiz_survey', $table_descr, true);
$db->CreateIndex('quiz_survey', 'idx_survey_users', 'created_by');

$table_descr = array(
	'id'	=>	"IDENTITY",
	'question'	=>	"VARCHAR(255) NULL",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'start_date' => "INT_DATE NOT_NULL DEFAULT 0",
	'end_date' => "INT_DATE NOT_NULL DEFAULT 0",
	'anonymous'	=>	"BOOL NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'copy_email'	=>	"BOOL NOT_NULL DEFAULT 0",
	'show_results'	=>	"BOOL NOT_NULL DEFAULT 0",
	'completion_msg' => "VARCHAR_MAX NULL"
);

$db->CreateTable('quiz_poll', $table_descr, true);
$db->CreateIndex('quiz_poll', 'idx_poll_users', 'created_by');

DB_UPDATE_FILE
);


$migrations->Run('02_quiz_survey_section.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// quiz
$table_descr = array(
	'id'	=>	"IDENTITY",
	'survey_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL"
);

$db->CreateTable('quiz_section', $table_descr, true);

$table_descr = array(
	'id'	=>	"IDENTITY",
	'section_id'	=>	"INT NOT_NULL DEFAULT 0",
	'question_id'	=>	"INT NOT_NULL DEFAULT 0"
);

$db->CreateTable('quiz_section_question', $table_descr, true);

$db->AlterColumn('quiz_attempt', 'quiz_id', 'object_id', "INT NOT_NULL DEFAULT 0");
$db->AddColumn('quiz_attempt', 'object_type', "INT NOT_NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('03_quiz_section_question_add.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();


$db->AddColumn('quiz_section_question', 'sort_order', "INT NOT_NULL DEFAULT 0");
$db->AddColumn('quiz_section_question', 'created_date', "INT_DATE NOT_NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('04_quiz_poll_question_junction_add.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// quiz_question_junction
$table_descr = [
	'id'	=>	"IDENTITY",
	'poll_id'	=>	"INT NOT_NULL DEFAULT 0",
	'question_id'	=>	"INT NOT_NULL DEFAULT 0",
	'sort_order'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
];

$db->CreateTable('quiz_poll_question_junction', $table_descr, true);
$db->CreateIndex('quiz_poll_question_junction', 'idx_poll_fk', 'poll_id');
$db->CreateIndex('quiz_poll_question_junction', 'idx_question_fk', 'question_id');

DB_UPDATE_FILE
);


$migrations->Run('05_quiz_survey_section_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_section', 'description', "VARCHAR_MAX NULL");
$db->AddColumn('quiz_section', 'sort_order', "INT NOT_NULL DEFAULT 0");
DB_UPDATE_FILE
);


$migrations->Run('06_quiz_option_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('quiz_option', 'points', 'points', "INT NULL DEFAULT NULL");
$db->AlterColumn('quiz_option', 'correct', 'correct', "INT NULL DEFAULT NULL");
$db->AlterColumn('quiz_option', 'sort_order', 'sort_order', "INT NULL DEFAULT NULL");

DB_UPDATE_FILE
);


$migrations->Run('07_quiz_poll_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->DropColumn('quiz_poll', 'question');

DB_UPDATE_FILE
);


$migrations->Run('08_quiz_attempt_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('quiz_attempt', 'object_type', 'object_type', "INT NOT_NULL DEFAULT 140");
$db->query('UPDATE quiz_attempt SET object_type = 140 WHERE object_type = 0');

DB_UPDATE_FILE
);


$migrations->Run('09_quiz_poll_add_multiple.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();
$db->AddColumn('quiz_poll', 'multiple', "BOOL NOT_NULL DEFAULT 0");


DB_UPDATE_FILE
);


$migrations->Run('10_quiz_poll_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_poll', 'description', "VARCHAR_MAX NULL");
DB_UPDATE_FILE
);


$migrations->Run('11_update_option_text.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('quiz_option', 'option_text', 'option_text', "VARCHAR_MAX NULL");
DB_UPDATE_FILE
);


$migrations->Run('12_anonymous.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// quiz_question_junction
$table_descr = [
	'user_id'	=>	"VARCHAR(255)",
	'object_type'	=>	"INT NOT_NULL DEFAULT 0",
	'object_id'	=>	"INT NOT_NULL DEFAULT 0"
];

$db->CreateTable('quiz_anonymous', $table_descr, true);

DB_UPDATE_FILE
);


$migrations->Run('13_answer_choice.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();



$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'attempt_id'	=>	"INT NOT_NULL DEFAULT 0",
	'question_id'	=>	"INT NOT_NULL DEFAULT 0",
	'option_id'	=>	"INT NOT_NULL DEFAULT 0",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0"
);

$db->CreateTable('quiz_answer_choice', $table_descr, true);

DB_UPDATE_FILE
);


$migrations->Run('14_admin_panel_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$survey_admin_class_id = 147;
$admin_rights = 273;
$object_id = $perm_owner_class_id = 1;


$db->query("DELETE FROM simple_acl WHERE object_code = str:object_code", 'polls-surveys');
$db->query("DELETE FROM permissions WHERE class_id = int:class_id", $survey_admin_class_id);

$result = $db->query("SELECT * FROM simple_acl WHERE object_code = str:object_code", 'surveys');

if($result->hasData())
{
	while ($row = $result->fetchArray())
	{
		$db->query("INSERT INTO simple_acl (object_code, user_id, rights)
		 VALUES (str:object_code, int:user_id, int:rights)", 'polls-surveys', $row['user_id'], $row['rights']);

		$db->query("INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights)
		 VALUES (int:class_id, int:object_id, int:perm_owner_class_id, int:perm_owner_id, int:rights)",
			$survey_admin_class_id, $object_id, $perm_owner_class_id, $row['user_id'], $admin_rights);
	}
}




DB_UPDATE_FILE
);


$migrations->Run('15_quiz_survey_notification.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_survey', 'has_notification', "INT NOT_NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('16_quiz_poll_notification.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_poll', 'has_notification', "INT NOT_NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('17_quiz_survey_poll_notification_sent.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_survey', 'notification_sent', "BOOL NULL DEFAULT 0");
$db->AddColumn('quiz_poll', 'notification_sent', "BOOL NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('18_ending_notifications.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_survey', 'end_notification_sent', "BOOL NULL DEFAULT 0");
$db->AddColumn('quiz_poll', 'end_notification_sent', "BOOL NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('19_is_new_flag.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('quiz_survey', 'is_new', "BOOL NULL DEFAULT 0");
$db->AddColumn('quiz_poll', 'is_new', "BOOL NULL DEFAULT 0");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('08.01');
