define(['jquery'], function ($) {
    return function () {

        $('cla-checkbox[name="start_date_time_active"]').on('change', '#start_date_time_active', function () {
            if ($('#start_date_time_active').is(':checked')) {
                $('#start_date, #start_time').removeAttr('disabled');
            } else {
                $('#start_date, #start_time').attr('disabled', true);
            }
        });

        $('cla-checkbox[name="end_date_time_active"]').on('change', '#end_date_time_active', function () {
            if ($('#end_date_time_active').is(':checked')) {
                $('#end_date, #end_time').removeAttr('disabled');
                $('#end_survey').show();

            } else {
                $('#end_date, #end_time').attr('disabled', true);
                $('#end_survey').hide();

            }
        });
        //check start date in not bigger than end date and vice versa
        $('#start_date, #start_time').on('change',  function () {
            checkDates('start');
        });
        $('#end_date, #end_time').on('change',  function () {
            checkDates('end');
        });

        function checkDates(date) {
            var s_date = $('#start_date').val();
            var s_time = $('#start_time').val();
            var s_date_obj = parse_date_to_object(s_date, s_time);
            var e_date = $('#end_date').val();
            var e_time = $('#end_time').val();
            var e_date_obj = parse_date_to_object(e_date, e_time);

            if (date === 'start' && s_date_obj > e_date_obj)
            {
                $('#end_date').val(s_date);
                $('#end_time').val(s_time);
            }
            if (date === 'end' && e_date_obj < s_date_obj)
            {
                $('#start_date').val(e_date);
                $('#start_time').val(e_time);
            }
        }

        if ($('cla-checkbox[name="end_date_time_active"]').attr('checked') == 'checked') {
            $('#end_survey').show();
        }else{
            $('#end_survey').hide();
        }

        // delete question
        $('.delete-question').click(function (e) {
            e.preventDefault()
            $('#delete-question-form').attr({action: $(this).attr('href')});
        });

        // delete section
        $('.delete-section').click(function (e) {
            e.preventDefault()
            $('#delete-section-form').attr({action: $(this).attr('href')});
        })

        $('.js-publish').click(function (e) {
            var option = $("[name='owners'] option");
            if (option.length === 0){
                e.preventDefault();
                alert(lmsg('quiz.admin.no_perm_notice'));
            }
        })
    }
})
