/**
 * Handles redirection to various Survey pages.
 */
(function () {
    'use strict';

    angular.module('cla.survey').service('surveyRedirect', surveyRedirect);

    surveyRedirect.$inject = ['growl.service', '$window'];

    function surveyRedirect(growlService, $window) {
        let service = {
            surveyUrl: surveyUrl,
            redirect: redirect,
            toSurvey: toSurvey,
            toSurveyList: toSurveyList
        };

        return service;

        /**
         * Get the path for a survey.
         *
         * @param {int} survey_id
         * @returns {string}
         */
        function surveyUrl(survey_id) {
            return `/polls-surveys/survey/${survey_id}/`;
        }

        /**
         * Redirect to the given path, optionally with a message and error flag.
         *
         * @param {string} pathname
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function redirect(pathname, message, is_error) {
            if (!message) {
                $window.location.pathname = pathname;

                return;
            }

            growlService.flash(message, null, is_error, pathname);
        }

        /**
         * Redirect to a Survey's intro page.
         *
         * @param {int} Survey_id
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toSurvey(survey_id, message, is_error) {
            service.redirect(surveyUrl(survey_id), message, is_error);
        }

        /**
         * Redirect to the Survey list page.
         *
         * @param {string} [message]
         * @param {boolean} [is_error]
         */
        function toSurveyList(message, is_error) {
            service.redirect('/polls-surveys', message, is_error);
        }
    }
}());
