define(['jquery'], function ($) {
    return function () {
        // click on the question type
        $('cla-picker[name="question_type"]').on('click', function (e) {
            let type = $(this).val()

            if (type === '0') {
                questionTypeHelper.showOptions();
                $('#survey_new_option_layout').removeClass('d-none');
            } else if (type === '1') {
                questionTypeHelper.showOptions();
                $('#survey_new_option_layout').addClass('d-none');
            } else if (type === '3') {
                questionTypeHelper.showFreeTextInput();
                $('#survey_new_option_layout').addClass('d-none');


                return questionTypeHelper.showSelectText();
            }
        });

        // button new option
        $('#add-new-option-filed').on('click', function (e) {
            e.preventDefault()
            $(this).animate({'margin-top': '45px'}, 300, 'easeOutCirc', function () {
                questionTypeHelper.newAnswer($(this));
            })

            return false;
        });

        // new option on enter
        $(document).on('keypress', function (e) {
            if (e.keyCode === 13 && $('.js-option-text').is(':focus')) {
                $('#add-new-option-filed').animate({'margin-top': '45px'}, 300, 'easeOutCirc', function () {
                    questionTypeHelper.newAnswer($(this));
                });

                return false;
            }
        });

        $('.options-container').on('click', '.js-delete', function(e) {
            e.preventDefault();
            questionTypeHelper.deleteAnswer($(this));
        });

        // read on change input type
        $('select[name="input_type_text"]').on('change', function () {
            if ($(this).val() === '3') {
                questionTypeHelper.showFreeTextInput()
            }

            if ($(this).val() === '5') {
                questionTypeHelper.showFreeTextTextarea()
            }
        })

        const validAnswerRegex = /\S/;
        $('.js-question-form').submit(function (event) {
            let question_text = $('#question_text');

            if (!question_text.val())
            {
                cla.showMessage(lmsg('quiz.admin.no_question'), null, true);
                return false;
            }

            let picker = $('cla-picker[name="question_type"].cla-picker-checked');

            if (picker && picker.val() == 3) {
                return;
            }

            let valid = 0;

            $('.js-question-form .js-option-text').each(function (index, answer) {
                if (validAnswerRegex.test($(answer).val())) {
                    valid++;
                }
            });

            if (valid < 2) {
                cla.showMessage('Please enter at least two options', null, true);

                event.preventDefault();
                return false;
            }
        });
        if (window.attempts > 0)
        {
            $(".js-option-text").attr("readonly", "true");
        }




        let questionTypeHelper = {
            answers: -1,
            html: '<div class="form-group row">' + $('#init-option-container').clone().html() + '</div>',
            /** create a new answer div and selection*/
            newAnswer: function ($answerDiv) {

                // decrement the answers count in to the negatives
                let index = --this.answers;

                // get selector and container
                let box = $(this.html).clone();

                // empty input field
                box.find('input#survey_new_option').val('')

                // set new opt id value
                box.find('.js-optid').val(index);

                $('.option-control').before(box);

                if ($answerDiv) {
                    $answerDiv.css('margin-top', '0');
                }

                $('.js-option-text').last().focus();
                box.animate({'opacity': '1'}, 1e3, 'easeOutCirc');

                this.updateRequired();

            },
            deleteAnswer: function ($deleteLink) {

                if ($deleteLink) {
                    let optionDiv = $deleteLink.parent().parent().parent();
                    let that = this;
                    optionDiv.fadeOut(200, function(){
                        $(this).remove();
                        that.updateRequired();
                    });
                }

            },
            showOptions: function () {
                $('#options-container').show()
                $('#options-input-type').addClass('d-none')
                $('#survey_new_option_layout').removeClass('d-none')
            },
            showSelectText: function () {
                $('#options-container').hide()
                $('#options-input-type').removeClass('d-none')
            },
            showFreeTextInput: function () {
                $('#options-input-type-short').removeClass('d-none')
                $('#options-input-type-long').addClass('d-none')
            },
            showFreeTextTextarea: function () {
                $('#options-input-type-short').addClass('d-none')
                $('#options-input-type-long').removeClass('d-none')
            },
            updateRequired: function () {
                $('#options-container').find('span.required').remove();
                let elements_to_update = $('#options-container label').slice(0, 2);
                elements_to_update.append('<span class="required">*</span>');
            }

        }

        questionTypeHelper.updateRequired();

        // set options or input type select on template init
        let defaultChecked = $('input[name="question_type_input_hidden"]').val()

        // add new question
        if (defaultChecked === '') {
            $('cla-picker[value="0"]').attr('checked', 1)
        }

        if (defaultChecked === '3') {
            questionTypeHelper.showSelectText()
            questionTypeHelper.showFreeTextInput()
        }

        if (defaultChecked === '5') {
            questionTypeHelper.showSelectText()
            questionTypeHelper.showFreeTextTextarea()
        }

        if (defaultChecked === '1') {
            $('#survey_new_option_layout').addClass('d-none')
        }

        if (defaultChecked === '0' || defaultChecked === '4') {
            $('#survey_new_option_layout').removeClass('d-none')
        }
    }
})
