/**
 * Controls the  quiz results
 *
 */
(function () {
    'use strict';

    angular.module('cla.survey').controller('reviewController', reviewController);

    reviewController.$inject = ['$scope', '$window', '$location', 'surveyTracker', 'surveyActions'];

    /**
     *
     * @param $scope
     * @param $window
     * @param $location
     * @param surveyTracker
     * @param surveyActions
     * @constructor
     */
    function reviewController($scope, $window, $location, surveyTracker, surveyActions) {

        $scope.content = null;
        $scope.finish = finish;
        $scope.back = back;
        $scope.getTotalQuestions = getTotalQuestions;
        $scope.getCompleteQuestions = getCompleteQuestions;
        $scope.getIncompleteQuestions = getIncompleteQuestions;

        $scope.reviewAll = reviewAll;
        $scope.reviewQuestions = reviewQuestions;

        $scope.survey_id = $window.survey_preload.survey.id;
        $scope.preview = $window.survey_preload.preview;

        $scope.canonicalUrl = $window.survey_preload.canonicalUrl;

        init();

        /**
         * initialise controller, with routing
         */
        function init() {
            if (!surveyTracker.sections.length) {
                angular.element("#survey-wrap").hide();
                surveyActions.start($scope.survey_id, function () {
                    angular.element("#survey-wrap").show();
                });
            }

            $scope.$on('survey.finished', $scope.finish);
            review();
        }

        /**
         * load review content
         */
        function review() {
            $scope.content = $window.survey_preload.survey;
        }

        /**
         * finish the survey
         */
        function finish() {
            surveyActions.finish($scope.survey_id, function () {
                if (!$scope.preview) {
                    $location.path('/finish');
                } else {
                    $window.location.href = '/survey/' + $scope.survey_id + '/review';
                }
            });
        }

        /**
         * back to survey
         */
        function back() {
            surveyTracker.resetTracker();
            $location.path('/continue');
        }

        /**
         * the total number of questions
         */
        function getTotalQuestions() {
            return $window.survey_preload.question_count;
        }

        /**
         * the number of questions a user has answered
         */
        function getCompleteQuestions() {
            return surveyTracker.getChosenCount();
        }

        /**
         * the number of questions the user has yet to answer
         */
        function getIncompleteQuestions() {
            var total = $window.survey_preload.question_count;
            var completed = $scope.getCompleteQuestions();
            return total - completed;
        }

        /**
         * review all questions
         */
        function reviewAll() {
            surveyTracker.resetTracker();
            $location.path('/continue');
        }

        /**
         * review complete or incomplete questions
         * @param as_complete
         */
        function reviewQuestions(as_complete) {
            var questions = as_complete ? surveyTracker.getComplete() : surveyTracker.getIncomplete();
            if (questions.length > 0) {
                // update tracker and set question to the first in the list
                surveyTracker.setTracker(questions);
                surveyTracker.question = surveyTracker.tracker[0];
                surveyTracker.update();

                $location.path('/continue');
            }
        }
    }
}());
